---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：16-ページ選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **cls_menuクラスの定義箇所**：getReplaceMenu()メソッドの詳細確認
  2. **パスワード継承処理**：resetAllSubPasswords()の動作確認
  3. **並び順再計算**：removeRang()とgetRang()の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_selectPage.asp` - メイン画面ソースコード
- E-02: `asp/bs_process.asp` - Insert処理（行41-64）
- E-03: `asp/bs_security.asp` - セキュリティ処理
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.16はページ選択画面である | E-04 | ○ |
| C-02 | URLパスはasp/bs_selectPage.aspである | E-01, E-04 | ○ |
| C-03 | secondAdmin.bPagesMoveで権限制御 | E-01 (行4) | ○ |
| C-04 | cls_menuでツリー表示を生成 | E-01 (行5-8) | ○ |
| C-05 | getReplaceMenu()でツリー生成 | E-01 (行8) | ○ |
| C-06 | menu.bOnline=falseで非公開も表示 | E-01 (行7) | ○ |
| C-07 | insertItem()でconfirm表示 | E-01 (行10-19) | ○ |
| C-08 | Insert時にcheckCSRF()実行 | E-02 (行42) | ○ |
| C-09 | parentPage.removeRang()で元親から除去 | E-02 (行44) | ○ |
| C-10 | iParentIDに新しい親を設定 | E-02 (行46) | ○ |
| C-11 | bLossePagina=falseに設定 | E-02 (行48) | ○ |
| C-12 | 親が非公開なら移動ページも非公開 | E-02 (行49-51) | ○ |
| C-13 | iRang=getRang+1で並び順設定 | E-02 (行53) | ○ |
| C-14 | 親のパスワードを継承 | E-02 (行55-58) | ○ |
| C-15 | page.save()で保存 | E-02 (行59) | ○ |
| C-16 | イントラネットはbs_intranetにリダイレクト | E-02 (行60-61) | ○ |
| C-17 | 通常はbs_defaultにリダイレクト | E-02 (行62-63) | ○ |
| C-18 | メインアイテム化リンクを表示 | E-01 (行5) | ○ |
| C-19 | 関連機能はページ移動・並び替え(No.11) | E-05 | ○ |
| C-20 | cls_menuの定義ファイル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_menuクラスの定義ファイルが確認できていない（getReplaceMenu()メソッドの実装詳細）
  - 候補：menu.asp / includes/menu.asp / 別のインクルードファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 移動処理の基本フローは明確に確認できた
- 1: 中リスク - ツリー表示の生成ロジック詳細確認推奨
- 1: 中リスク - 自己参照（自分の子に移動）防止の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ページ移動後、ツリー構造が正しく更新されることを確認
- [ ] 親ページのパスワードが子ページに正しく継承されることを確認
- [ ] 非公開ページへの移動時、移動ページも非公開になることを確認
- [ ] 自分自身の子ページへの移動が防止されることを確認
- [ ] フリーページ（bLossePagina）からの移動が正しく動作することを確認
