---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：161-印刷ページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：CSSファイル名の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `printPage.asp` 1-15行目
- E-02: `asp/begin.asp` 1-204行目
- E-03: `asp/process.asp` 1-290行目
- E-04: `asp/includes/page.asp`（cls_pageクラス定義）
- E-05: `asp/includes/customer.asp`（cls_customerクラス定義）
- E-06: `asp/includes/insertConstants.asp`（treatConstants関数）
- E-07: `画面一覧.csv` 161行目
- E-08: `画面機能マッピング.csv` 201行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 印刷ページはprintPage.aspで実装されている | E-01, E-07 | ○ |
| C-02 | printReplies=trueでテンプレート非使用モードになる | E-01 1行目, E-03 278-284行目 | ○ |
| C-03 | onloadイベントでwindow.print()が呼ばれる | E-01 10行目 | ○ |
| C-04 | ページIDはiIdパラメータで渡される | E-01 4行目, E-02 193行目 | ○ |
| C-05 | selectedPage.showTitleでタイトルを取得 | E-01 4行目 | ○ |
| C-06 | treatConstants関数で定数置換を行う | E-01 11行目, E-06 | ○ |
| C-07 | replaceBlocks関数でブロック置換を行う | E-01 11行目, E-04 | ○ |
| C-08 | sApplicationが設定されている場合はResponse.End | E-01 8行目 | ○ |
| C-09 | begin.aspで初期化処理が行われる | E-01 1行目, E-02 | ○ |
| C-10 | process.aspでページ処理が行われる | E-01 1行目, E-03 | ○ |
| C-11 | QS_CHARSETで文字コードが設定される | E-01 5行目, E-02 19行目 | ○ |
| C-12 | cleanUPASP関数で後処理が行われる | E-01 14行目 | ○ |
| C-13 | tdirでテキスト方向が設定される | E-01 6行目 | ○ |
| C-14 | 関連機能はページ印刷（113）とページ表示（99） | E-08 | ○ |
| C-15 | sorttable.jsがインクルードされる | E-01 7行目 | ○ |
| C-16 | ページコンテンツはtblPageから取得される | E-04, E-02 192-196行目 | ○ |
| C-17 | isLeeg関数で空チェックを行う | E-01 8行目 | ○ |
| C-18 | CSSファイルはqs_ltr.cssまたはqs_rtl.css | E-01 6行目 | △ |

## 4) 不足情報（Unknown / Missing）
- C-18：CSSファイルの実際のパスと存在確認が必要
  - 候補：`quickersite/css/qs_ltr.css` / `quickersite/css/qs_rtl.css`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 印刷機能は単純なHTML出力のため、セキュリティ上の重大なリスクは低い
- 1: 中リスク - パスワード保護ページへのアクセス制御はprocess.aspで行われているが、直接URL入力時の動作を確認すべき

## 6) レビュアーチェックリスト（最小）
- [ ] printReplies=trueの設定がテンプレートバイパスに正しく機能しているか
- [ ] sApplicationチェックによるResponse.Endが適切に動作するか
- [ ] 認証が必要なページへの直接アクセス時の動作確認
- [ ] CSSファイルの実際のパスと存在を確認
- [ ] window.print()の各ブラウザでの動作確認
