---
generated_at: 2026-01-23 22:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：162-RSS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **C-22**：addHitRSSメソッドの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rss.asp` 1-235行目
- E-02: `asp/includes/rss_writer.asp` 1-290行目
- E-03: `asp/begin.asp` 1-204行目
- E-04: `asp/includes/page.asp`
- E-05: `asp/includes/customer.asp`
- E-06: `asp/includes/theme.asp`
- E-07: `asp/includes/catalog.asp`
- E-08: `asp/includes/itemSearch.asp`
- E-09: `画面一覧.csv` 162行目
- E-10: `画面機能マッピング.csv` 202行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSSフィードはrss.aspで生成される | E-01, E-09 | ○ |
| C-02 | Content-Typeはapplication/xmlに設定 | E-01 4行目 | ○ |
| C-03 | kwRSS_writerクラスでRSS生成 | E-01 7行目, E-02 | ○ |
| C-04 | iId=0の場合サイト全体RSS | E-01 9行目 | ○ |
| C-05 | bEnableMainRSSでサイト全体RSS有効判定 | E-01 11行目, E-05 | ○ |
| C-06 | アプリケーションオブジェクトにキャッシュ | E-01 13行目, 51行目, 217行目 | ○ |
| C-07 | 最大300件のページを取得 | E-01 25行目 | ○ |
| C-08 | 公開条件チェック（bOnline, bDeleted等） | E-01 30行目 | ○ |
| C-09 | イントラネット未認証時は「No Access」 | E-01 63-78行目 | ○ |
| C-10 | bPushRSSでリストページRSS判定 | E-01 91行目, E-04 | ○ |
| C-11 | fastlistitemsでリストアイテム取得 | E-01 94行目, E-04 | ○ |
| C-12 | ユーザーフレンドリーURLを使用 | E-01 97-101行目 | ○ |
| C-13 | enclosure要素で画像添付 | E-01 116-118行目 | ○ |
| C-14 | Format_RFC822_DateAndTimeで日付変換 | E-01 36行目, 120行目 | ○ |
| C-15 | iThemeIDでフォーラム判定 | E-01 133行目 | ○ |
| C-16 | theme.postsで投稿取得 | E-01 144行目, E-06 | ○ |
| C-17 | comments要素を追加 | E-01 165行目 | ○ |
| C-18 | selectedPage.catalogでカタログ取得 | E-01 176行目, E-07 | ○ |
| C-19 | itemSearchでカタログアイテム検索 | E-01 183-188行目, E-08 | ○ |
| C-20 | treatConstantsで定数置換 | E-01 51行目, 224行目 | ○ |
| C-21 | logRefererでリファラーログ記録 | E-01 228行目 | ○ |
| C-22 | addHitRSSでRSSヒット数更新 | E-01 226行目 | △ |

## 4) 不足情報（Unknown / Missing）
- C-22：addHitRSSメソッドの実装詳細（page.asp内）の確認が必要
  - 候補：`asp/includes/page.asp` 内のaddHitRSSメソッド定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RSS出力は読み取り専用でセキュリティリスク低い
- 1: 中リスク - イントラネットコンテンツのRSS出力時の認証確認
- 1: 中リスク - キャッシュの無効化タイミング（コンテンツ更新時）

## 6) レビュアーチェックリスト（最小）
- [ ] bEnableMainRSSの設定がない場合の動作確認
- [ ] イントラネット認証チェックの確実性
- [ ] キャッシュ無効化のトリガー確認
- [ ] RFC 822日付フォーマットの正確性
- [ ] enclosure要素のMIMEタイプがimage/jpeg固定で問題ないか
- [ ] 300件制限が適切かどうか
