---
generated_at: 2026-01-23 22:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：163-サイトマップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**：Content-Type設定の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sitemap.asp` 1-61行目
- E-02: `asp/includes/search.asp` 1-171行目
- E-03: `asp/begin.asp`
- E-04: `asp/includes/page.asp`
- E-05: `asp/includes/customer.asp`
- E-06: `画面一覧.csv` 163行目
- E-07: `画面機能マッピング.csv` 203行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XMLサイトマップはsitemap.aspで生成される | E-01, E-06 | ○ |
| C-02 | sitemaps.org仕様（バージョン0.9）に準拠 | E-01 10-14行目 | ○ |
| C-03 | cls_searchクラスでページ一覧取得 | E-01 17行目, E-02 | ○ |
| C-04 | includeURL=falseで外部URLを除外 | E-01 18行目, E-02 16-17行目 | ○ |
| C-05 | allowEmptyString=trueで全ページ取得 | E-01 19行目, E-02 17行目 | ○ |
| C-06 | includeListItems=trueでリストアイテムを含む | E-01 20行目, E-02 19行目 | ○ |
| C-07 | iThemeIDでフォーラム判定 | E-01 29行目 | ○ |
| C-08 | 親投稿のみ取得（iPostID is null or iPostID=0） | E-01 32行目 | ○ |
| C-09 | iListPageIDでリストアイテム判定 | E-01 44行目 | ○ |
| C-10 | bUserFriendlyURLでUFL判定 | E-01 47行目, E-05 | ○ |
| C-11 | encrypt関数でページIDを暗号化 | E-01 35, 45, 51行目 | ○ |
| C-12 | customer.sQSUrlでサイトURLを取得 | E-01 35行目, E-05 | ○ |
| C-13 | cleanUPASPで後処理 | E-01 60行目 | ○ |
| C-14 | loc要素のみを出力（lastmod等なし） | E-01 42-53行目 | ○ |
| C-15 | 関連機能はXMLサイトマップ出力（115） | E-07 | ○ |
| C-16 | Content-Typeが設定されていない | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- C-16：sitemap.aspではContent-Typeが明示的に設定されていないため、デフォルトのtext/htmlになる可能性
  - 検索エンジンは通常.xmlファイルを期待するため、確認が必要
  - 候補：Response.ContentType = "application/xml" の追加を検討

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Content-Type未設定により検索エンジンが正しく認識しない可能性
- 0: 低リスク - 出力内容は読み取り専用でセキュリティリスク低い
- 0: 低リスク - 公開ページのみのため情報漏洩リスクなし

## 6) レビュアーチェックリスト（最小）
- [ ] Content-Typeがapplication/xmlまたはtext/xmlに設定されているか確認
- [ ] XMLサイトマップのバリデーション（xml-sitemaps.com等で検証）
- [ ] フォーラム投稿のURL形式が検索エンジンに適切か
- [ ] ページ数が多い場合のパフォーマンス確認
- [ ] encodeForXML等のエスケープ処理がURLに適用されているか
- [ ] 検索エンジンへの登録手順の確認
