---
generated_at: 2026-01-23 22:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：164-ログイン処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：logonItemメソッドの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_login.asp` 1-26行目
- E-02: `asp/process.asp` 133行目（pageAction分岐）
- E-03: `asp/begin.asp`
- E-04: `asp/includes/logonEdit.asp`
- E-05: `asp/includes/page.asp`
- E-06: `asp/includes/messages.asp`
- E-07: `画面一覧.csv` 164行目
- E-08: `画面機能マッピング.csv` 204-205行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン処理はprocess_login.aspで実装 | E-01, E-07 | ○ |
| C-02 | pageAction="login"でこの処理が呼ばれる | E-01 2行目, E-02 | ○ |
| C-03 | logon.logonItemでパスワード検証 | E-01 3行目, E-04 | ○ |
| C-04 | 認証成功時はリダイレクト | E-01 4行目 | ○ |
| C-05 | 認証失敗時はerr_loginエラー | E-01 6行目, E-06 | ○ |
| C-06 | フォームaction="default.asp" | E-01 9行目 | ○ |
| C-07 | hidden inputでiIdを渡す | E-01 10行目 | ○ |
| C-08 | hidden inputでpageActionを渡す | E-01 11行目 | ○ |
| C-09 | パスワード最大長15文字 | E-01 17行目 | ○ |
| C-10 | input type="password"を使用 | E-01 17行目 | ○ |
| C-11 | required属性で必須入力 | E-01 17行目 | ○ |
| C-12 | sanitize関数でXSS対策 | E-01 21行目 | ○ |
| C-13 | l()関数で多言語対応 | E-01 12, 16, 21行目 | ○ |
| C-14 | mailtoリンクでパスワード問い合わせ | E-01 13行目 | ○ |
| C-15 | customer.webmasterEmailを宛先に使用 | E-01 13行目 | ○ |
| C-16 | JavaScriptでフォーカス設定 | E-01 25行目 | ○ |
| C-17 | pageTitleにページタイトルを設定 | E-01 26行目 | ○ |
| C-18 | Cookie保存はlogonItemメソッド内で実行 | E-04 | △ |

## 4) 不足情報（Unknown / Missing）
- C-18：logonItemメソッド内でのCookie保存処理の詳細確認が必要
  - 候補：`asp/includes/logonEdit.asp` 内のlogonItemメソッド定義

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - パスワードが平文で比較されている可能性（ハッシュ化未確認）
- 1: 中リスク - Cookie保存時の暗号化の確実性
- 1: 中リスク - ブルートフォース攻撃対策（試行回数制限など）の有無

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードがハッシュ化されて保存・比較されているか確認
- [ ] Cookie保存時の暗号化方式の確認
- [ ] ブルートフォース攻撃対策の有無確認
- [ ] CSRFトークンの有無確認
- [ ] パスワード入力欄のautocomplete属性設定確認
- [ ] SSL/TLS通信の強制設定確認
