---
generated_at: 2026-01-23 22:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：165-検索処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **C-20**：Cookie保存処理の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_search.asp` 1-43行目
- E-02: `asp/includes/search.asp` 1-171行目
- E-03: `asp/process.asp` 50行目（pageAction分岐）
- E-04: `asp/begin.asp`
- E-05: `画面一覧.csv` 165行目
- E-06: `画面機能マッピング.csv` 206行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 検索処理はprocess_search.aspで実装 | E-01, E-05 | ○ |
| C-02 | pageAction="search"で呼び出される | E-03 | ○ |
| C-03 | キーワード最大100文字 | E-01 2行目, E-02 34行目 | ○ |
| C-04 | FormとQueryString両対応 | E-01 2-3行目 | ○ |
| C-05 | includeListItems=true設定 | E-01 5行目 | ○ |
| C-06 | bIncludeHideFromSearch=false設定 | E-01 6行目 | ○ |
| C-07 | search.resultsで検索実行 | E-01 7行目, E-02 31行目 | ○ |
| C-08 | QS_searchResults divで囲む | E-01 9行目 | ○ |
| C-09 | sApplication判定で分岐 | E-01 11行目 | ○ |
| C-10 | iListPageID判定でリストアイテム検出 | E-01 14行目 | ○ |
| C-11 | sLPExternalURL判定で外部URL分岐 | E-01 15, 18行目 | ○ |
| C-12 | bLPExternalOINWで新規ウィンドウ判定 | E-01 20行目 | ○ |
| C-13 | iPostIDでフォーラム投稿判定 | E-01 27行目 | ○ |
| C-14 | 本文先頭150文字をスニペット表示 | E-01 17, 24, 29, 32行目 | ○ |
| C-15 | キーワードを太字に置換 | E-01 17行目（replace...b...） | ○ |
| C-16 | vbTextCompare(1)で大文字小文字無視 | E-01 17行目 | ○ |
| C-17 | results.countで件数表示 | E-01 43行目 | ○ |
| C-18 | treatConstantsで定数置換 | E-01 17, 39行目 | ○ |
| C-19 | 関連機能はサイト内検索（102） | E-06 | ○ |
| C-20 | 検索キーワードをCookie保存 | E-02 32行目 | △ |

## 4) 不足情報（Unknown / Missing）
- C-20：Cookie保存（search.asp 32行目）の詳細動作確認が必要
  - 保存されるCookie名、有効期限、使用箇所の確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - SQLインジェクション対策（cleanup関数の確実性）
- 1: 中リスク - XSS対策（検索キーワードのサニタイズ）
- 0: 低リスク - 検索結果が大量の場合のパフォーマンス（250件制限あり）

## 6) レビュアーチェックリスト（最小）
- [ ] cleanup関数がSQLインジェクションを完全に防いでいるか
- [ ] 検索キーワードのHTMLエスケープが適切か
- [ ] 250件制限が適切か確認
- [ ] 3文字未満の検索制限がUXに影響しないか
- [ ] イントラネット検索時の認証チェックが確実か
- [ ] Cookie保存のセキュリティ（HttpOnly等）確認
