---
generated_at: 2026-01-23 23:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：168-プロフィール処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **C-22**：パスワード保存形式（平文/ハッシュ）の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_profile.asp` 1-118行目
- E-02: `asp/includes/contact.asp`
- E-03: `asp/includes/contactField.asp`
- E-04: `asp/includes/ticket.asp`
- E-05: `asp/process.asp` 140-143行目
- E-06: `asp/includes/customer.asp`
- E-07: `画面一覧.csv` 168行目
- E-08: `画面機能マッピング.csv` 209行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロフィール処理はprocess_profile.aspで実装 | E-01, E-07 | ○ |
| C-02 | pageAction="profile"で呼び出される | E-05 | ○ |
| C-03 | acパラメータでアクティベーションチケット取得 | E-01 3行目, E-04 | ○ |
| C-04 | 未認証＋無効チケットでリダイレクト | E-01 4-9行目 | ○ |
| C-05 | contactFieldsでカスタムフィールド取得 | E-01 14行目, E-06 | ○ |
| C-06 | checkCSRF()でCSRF検証 | E-01 17行目 | ○ |
| C-07 | getRequestValues()でフォーム値取得 | E-01 18行目, E-02 | ○ |
| C-08 | allowDE=trueで重複メール許可 | E-01 20行目 | ○ |
| C-09 | save()でコンタクト保存 | E-01 21行目, E-02 | ○ |
| C-10 | 成功時fb_saveOKメッセージ | E-01 22行目 | ○ |
| C-11 | Cookie設定（sPw、sEmail） | E-01 23-24行目 | ○ |
| C-12 | 新規登録時はticket.remove() | E-01 26行目 | ○ |
| C-13 | 管理者通知メール送信（bSendMailUponNewMember） | E-01 27-35行目, E-06 | ○ |
| C-14 | iDefaultStatusでステータス設定 | E-01 41行目, E-06 | ○ |
| C-15 | 新規会員はウェルカムページへリダイレクト | E-01 43行目 | ○ |
| C-16 | メール最大50文字 | E-01 57行目 | ○ |
| C-17 | パスワード最大20文字 | E-01 61行目 | ○ |
| C-18 | ニックネーム最大50文字 | E-01 65行目 | ○ |
| C-19 | bGetEmailsFromSiteでPM許可設定 | E-01 68-69行目 | ○ |
| C-20 | カスタムフィールドはbProfile判定 | E-01 74行目 | ○ |
| C-21 | アバター機能はcustomer.bUseAvatars判定 | E-01 113-115行目 | ○ |
| C-22 | パスワードの保存形式（平文/ハッシュ） | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- C-22：contact.asp内でのパスワード保存処理の詳細確認が必要
  - セキュリティ上、ハッシュ化されていることが望ましい
  - 候補：`asp/includes/contact.asp` 内のsaveメソッド

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - パスワードが平文で保存・Cookie設定されている可能性
- 1: 中リスク - メールアドレス変更時の再認証がない可能性
- 1: 中リスク - カスタムフィールドのXSS対策確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードがハッシュ化されて保存されているか確認
- [ ] Cookieに保存されるパスワードの形式確認
- [ ] メールアドレス変更時の本人確認処理確認
- [ ] カスタムフィールドのサニタイズ処理確認
- [ ] リッチテキストフィールドのXSS対策確認
- [ ] アクティベーションチケットの有効期限確認
