---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-パスワード適用

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **パスワード継承の動作確認**：resetAllSubPasswords()の実際の動作検証
  2. **フロントエンドでのパスワード認証**：閲覧時のパスワード入力UIの確認
  3. **親パスワードとの競合**：親ページパスワード設定時の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_applyPW.asp` - メイン画面ソースコード
- E-02: `asp/bs_processPage.asp` - パスワード処理（行45-81）
- E-03: `asp/includes/page.asp` - cls_pageクラス
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.17はパスワード適用画面である | E-04 | ○ |
| C-02 | URLパスはasp/bs_applyPW.aspである | E-01, E-04 | ○ |
| C-03 | secondAdmin.bPagesPWで権限制御 | E-01 | ○ |
| C-04 | customer.sTotalPWで条件分岐 | E-01 | ○ |
| C-05 | sTotalPW設定時は個別設定不可 | E-01 | ○ |
| C-06 | parentPage.sPwで削除ボタン非表示判定 | E-01 | ○ |
| C-07 | パスワード入力は最大15文字 | E-01 (maxlength=15) | ○ |
| C-08 | save_pwでパスワード保存 | E-02 (行45-60) | ○ |
| C-09 | パスワード3文字未満でエラー | E-02 (行48-49) | ○ |
| C-10 | lcase()で小文字変換 | E-02 (行51) | ○ |
| C-11 | resetAllSubPasswords()で子ページ同期 | E-02 (行53) | ○ |
| C-12 | delete_pwでパスワード削除 | E-02 (行61-70) | ○ |
| C-13 | delete_pw_allで一括削除 | E-02 (行71-81) | ○ |
| C-14 | removeAllSubPasswords()で子ページも削除 | E-02 (行75) | ○ |
| C-15 | checkCSRF()でトークン検証 | E-02 | ○ |
| C-16 | イントラネットはbs_intranetにリダイレクト | E-02 | ○ |
| C-17 | 通常はbs_defaultにリダイレクト | E-02 | ○ |
| C-18 | 関連機能はページパスワード保護(No.15) | E-05 | ○ |
| C-19 | err_pwメッセージでエラー表示 | E-02 (行49) | ○ |
| C-20 | pwexplメッセージで説明表示 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して根拠が確認できた
- 1: 中リスク - フロントエンドでのパスワード認証UIの確認推奨
- 1: 中リスク - パスワードの暗号化/平文保存の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード3文字未満の入力でエラーが表示されることを確認
- [ ] 子ページへのパスワード継承が正しく動作することを確認
- [ ] 親ページにパスワードがある場合、削除ボタンが非表示になることを確認
- [ ] サイト全体パスワード設定時に個別設定が不可になることを確認
- [ ] フロントエンドでパスワード保護ページにアクセスした際の認証UIを確認
