---
generated_at: 2026-01-23 23:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：170-パスワード忘れ処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：resetPWメソッドの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_forgotPW.asp` 1-30行目
- E-02: `asp/includes/logonEdit.asp`
- E-03: `asp/process.asp` 148-151行目
- E-04: `asp/includes/captcha.asp`
- E-05: `asp/includes/mail_message.asp`
- E-06: `画面一覧.csv` 170行目
- E-07: `画面機能マッピング.csv` 211行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワード忘れ処理はprocess_forgotPW.aspで実装 | E-01, E-06 | ○ |
| C-02 | pageAction="forgotPW"で呼び出される | E-03 | ○ |
| C-03 | intranetUse有効時のみアクセス可能 | E-03 | ○ |
| C-04 | CAPTCHA検証を実行 | E-01 3行目 | ○ |
| C-05 | Session("captcha")と比較 | E-01 3行目 | ○ |
| C-06 | LCase比較で大文字小文字無視 | E-01 3行目 | ○ |
| C-07 | CAPTCHA不一致でerr_captcha | E-01 4行目 | ○ |
| C-08 | logon.resetPW()でリセット処理 | E-01 5行目, E-02 | ○ |
| C-09 | 成功時fb_emailFoundメッセージ | E-01 6行目 | ○ |
| C-10 | 失敗時err_emailNotFound | E-01 8行目 | ○ |
| C-11 | pageTitle=l("forgotPW") | E-01 11行目 | ○ |
| C-12 | 説明文l("forgotPwExpl") | E-01 14行目 | ○ |
| C-13 | input type="email"を使用 | E-01 18行目 | ○ |
| C-14 | CAPTCHA画像はcaptcha.asp | E-01 22行目, E-04 | ○ |
| C-15 | CAPTCHA最大4文字 | E-01 22行目 | ○ |
| C-16 | JavaScriptでフォーカス設定 | E-01 30行目 | ○ |
| C-17 | 関連機能はパスワード再発行（106） | E-07 | ○ |
| C-18 | resetPWメソッドで新パスワード生成・送信 | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- C-18：logonEdit.asp内のresetPWメソッドの実装詳細確認が必要
  - 新パスワードの生成方法
  - パスワード更新処理
  - メール送信内容

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 新パスワードがメールで平文送信される可能性
- 1: 中リスク - レート制限なしでブルートフォース攻撃の可能性
- 1: 中リスク - メールアドレスの存在確認によるアカウント列挙攻撃

## 6) レビュアーチェックリスト（最小）
- [ ] resetPWメソッドの実装詳細を確認
- [ ] 新パスワードの生成アルゴリズムが十分にランダムか
- [ ] パスワードがメールで平文送信されていないか確認
- [ ] パスワードリセットの試行回数制限の有無確認
- [ ] メールアドレス未登録時のレスポンスがアカウント列挙攻撃に悪用されないか
- [ ] CAPTCHA画像のセキュリティレベル確認
