---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：171-カタログ処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **オンライン期間フィルタリング詳細**：SQLの完全な実装確認が必要
  2. **ファイルタイプ表示の優先順**：表示順序ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_catalog.asp` 行1-129
- E-02: `asp/includes/itemSearch.asp` 行1-342
- E-03: `asp/includes/catalogItem.asp` 行1-410
- E-04: `asp/includes/catalog.asp`（インクルードファイル参照）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行212
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 行172

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カタログはbOnlineフラグで公開状態を判定 | E-01 行4 `if catalog.bOnline then` | ○ |
| C-02 | 検索フィールドは"public,search"属性で取得 | E-01 行6 `catalog.fields("public,search")` | ○ |
| C-03 | cls_itemSearchで検索処理を実行 | E-01 行8-13, E-02 | ○ |
| C-04 | pageAction=catalogでフォーム送信 | E-01 行19 `<input type='hidden' name='pageAction' value='catalog' />` | ○ |
| C-05 | iIDは暗号化されて送信 | E-01 行20 `encrypt(selectedPage.iId)` | ○ |
| C-06 | 検索フォームはbSearchable時のみ表示 | E-01 行23-46 `if catalog.bSearchable then` | ○ |
| C-07 | テキスト型、日付型、チェックボックス型、セレクト型の検索フィールドをサポート | E-01 行29-41 `select case searchFields(sf).sType` | ○ |
| C-08 | JQDatePickerで日付入力 | E-01 行35 `JQDatePicker("solo" & encrypt(sf))` | ○ |
| C-09 | resultItemsで検索結果を取得 | E-01 行51, E-02 行154-188 | ○ |
| C-10 | browseTableでページネーション表示 | E-01 行52, E-02 行189-206 | ○ |
| C-11 | アイテム画像はsPicExt存在時に表示 | E-01 行62-67 `if not isLeeg(resultItems(itemKey).sPicExt) then` | ○ |
| C-12 | showPicでサムネイル生成 | E-01 行65, E-03 行18-40 | ○ |
| C-13 | 公開フィールドのみ表示対象 | E-01 行69 `for each catalogField in catalogFields` (public) | ○ |
| C-14 | フィールドタイプに応じた表示切替 | E-01 行74-83 `select case catalogFields(catalogField).sType` | ○ |
| C-15 | 添付ファイルはfileTypesに基づき表示 | E-01 行89-106 | ○ |
| C-16 | フォームリンクはiFormID設定時に表示 | E-01 行109-116 `if isNumeriek(catalog.iFormID) then` | ○ |
| C-17 | bFormフラグでフォーム表示可否を制御 | E-01 行110 `if resultItems(itemKey).bForm then` | ○ |
| C-18 | treatConstantsで定数展開 | E-01 行119 `treatConstants(pageCatalog,true)` | ○ |
| C-19 | cls_itemSearchでfixedSQLを生成 | E-02 行42-113 | ○ |
| C-20 | オンライン期間でフィルタリング | E-02 行67-68 | ○ |
| C-21 | ページサイズはcatalog.iPageSizeを使用 | E-02 行165, 208 | ○ |
| C-22 | absolutepageでページ位置を管理 | E-02 行29, 171 | ○ |
| C-23 | 検索条件はinputFields/dateFieldsで管理 | E-02 行20-21, 114-133 | ○ |
| C-24 | 主機能は「カタログ表示」（機能No.101） | E-05 | ○ |
| C-25 | テンプレートファイルはasp/process_catalog.asp | E-06 | ○ |
| C-26 | 検索リセットはシンプルリンクへリダイレクト | E-01 行43 `location.assign('" & selectedPage.getSimpleLink & "')` | ○ |
| C-27 | オンライン期間の完全なフィルタリング実装 | **根拠なし** | △ |
| C-28 | ファイルタイプの表示優先順制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- オンライン期間フィルタリングの完全な実装詳細
  - 候補：tblCatalogItemのdOnlineFrom/dOnlineUntillカラム定義 / データベーススキーマ / テスト仕様
- ファイルタイプの表示順序ロジック
  - 候補：tblCatalogFileTypeのiRangカラム / カスタムソート設定

## 5) リスクフラグ（レビュー観点）
- 0: オンライン期間フィルタリングの境界条件（日付の等号・不等号処理）
- 1: 暗号化されたパラメータのデコード失敗時の挙動
- 0: 検索結果0件時のUI表示

## 6) レビュアーチェックリスト（最小）
- [ ] E-02 行67-68のオンライン期間SQLが正しい日付比較を行っているか確認
- [ ] E-01の検索フォーム生成が全フィールドタイプに対応しているか確認
- [ ] ページネーションの境界条件（最初/最後ページ）が適切に処理されているか確認
- [ ] 定数展開（treatConstants）が適切にXSS対策されているか確認
