---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：172-リストページ処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **アコーディオンモードの詳細実装**：getAccordeonList関数の完全な仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_listpage.asp` 行1-88
- E-02: `asp/includes/page.asp`（インクルードファイル参照）
- E-03: `asp/includes/feed.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行213
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行173

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pageListPageにリスト表示HTMLを格納 | E-01 行2 `pageListPage="<div id='QS_list'>"` | ○ |
| C-02 | fastlistitemsでアイテム取得 | E-01 行3 `set listitems=selectedPage.fastlistitems` | ○ |
| C-03 | iFormID設定時にpageHasFormフラグを立てる | E-01 行6-10 `if isNumeriek(selectedPage.iFormID) then pageHasForm=true` | ○ |
| C-04 | bAccordeonでアコーディオンモード分岐 | E-01 行12,82 `if not convertBool(selectedPage.bAccordeon) then` | ○ |
| C-05 | bHideDateで日付表示を制御 | E-01 行16 `selectedListItem.bHideDate=selectedPage.bHideDate` | ○ |
| C-06 | sLPExternalURLで外部URL判定 | E-01 行17 `isLPEU=not isLeeg(selectedListItem.sLPExternalURL) and...` | ○ |
| C-07 | encryptでアイテムIDを暗号化 | E-01 行18 `encryptedListkey=encrypt(listkey)` | ○ |
| C-08 | Request.Form("item")でPOST判定 | E-01 行22 `pageCondition=Request.Form ("item")=encryptedListkey` | ○ |
| C-09 | Request.QueryString("item")でGET判定 | E-01 行24-26 `if Request.QueryString ("item")=encryptedListkey then` | ○ |
| C-10 | SEOタイトル動的設定 | E-01 行25 `selectedPage.sSEOtitle=quotrep(selectedListItem.sTitle & " \| "...)` | ○ |
| C-11 | bLPExternalOINWで新規ウィンドウ制御 | E-01 行31-33 `if convertBool(selectedListItem.bLPExternalOINW) then...target='_blank'` | ○ |
| C-12 | minus2.gif/plus2.gifでアイコン表示 | E-01 行37,39 `minus2.gif`, `plus2.gif` | ○ |
| C-13 | link.gifで外部リンクアイコン表示 | E-01 行34 `link.gif` | ○ |
| C-14 | item=closeで折りたたみ | E-01 行36,37 `item=close` | ○ |
| C-15 | iLPOpenByDefaultで初期展開数制御 | E-01 行36 `LPCounter<convertGetal(selectedPage.iLPOpenByDefault)` | ○ |
| C-16 | bOpenOnloadで全展開モード | E-01 行36,43 `convertBool(selectedPage.bOpenOnload)` | ○ |
| C-17 | printRepliesで印刷モード判定 | E-01 行36,43 `printReplies or pageCondition or...` | ○ |
| C-18 | sDateAndTitleでタイトル表示 | E-01 行54 `selectedListItem.sDateAndTitle` | ○ |
| C-19 | listitemPicIMGTagで画像表示 | E-01 行58 `selectedListItem.listitemPicIMGTag` | ○ |
| C-20 | insertMediaでメディア挿入処理 | E-01 行60 `selectedListItem.page.insertMedia(selectedListItem.sValue)` | ○ |
| C-21 | iFeedIdでフィード埋め込み | E-01 行62 `if not isLeeg(selectedListItem.iFeedId) then...selectedListItem.Feed.build()` | ○ |
| C-22 | getAccordeonListでアコーディオン表示 | E-01 行83 `pageListPage=selectedPage.getAccordeonList` | ○ |
| C-23 | treatConstantsで定数展開 | E-01 行85 `treatConstants(pageListPage,true)` | ○ |
| C-24 | アコーディオンモードの完全な実装詳細 | **根拠なし**（getAccordeonList関数本体未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- getAccordeonList関数の完全な実装
  - 候補：page.aspのgetAccordeonListメソッド / jQuery UIアコーディオン連携コード

## 5) リスクフラグ（レビュー観点）
- 0: 展開条件の複合判定（行36,43）の意図通りの動作
- 0: 外部URL設定時のセキュリティ（オープンリダイレクト対策）
- 1: アコーディオンモードとの整合性

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 行36,43の展開条件が全ユースケースを網羅しているか確認
- [ ] 外部URL（sLPExternalURL）のバリデーションが適切か確認
- [ ] アコーディオンモード（bAccordeon）の動作を実機確認
- [ ] SEOタイトル設定が検索エンジン最適化に適切か確認
