---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：173-アイテム表示処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全てのClaimに根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_showitem.asp` 行1-7
- E-02: `asp/includes/catalogItem.asp` 行1-410
- E-03: `asp/includes/catalog.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行214-215
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行174

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cls_catalogItemオブジェクトを生成 | E-01 行3 `set showItem=new cls_catalogItem` | ○ |
| C-02 | sFicheITEMVIEWでテンプレートベース表示 | E-01 行4 `pageBody=showItem.sFicheITEMVIEW` | ○ |
| C-03 | pageTitleにアイテムタイトル設定 | E-01 行5 `pageTitle=showItem.sTitle` | ○ |
| C-04 | sSEOTitleを動的設定 | E-01 行6 `selectedPage.sSEOTitle=showItem.sSEOTitle` | ○ |
| C-05 | Class_InitializeでリクエストからiItemIDを取得 | E-02 行11-13 `pick(decrypt(request("iItemID")))` | ○ |
| C-06 | pick関数でDBからアイテム情報取得 | E-02 行50-79 | ○ |
| C-07 | sFicheITEMVIEW関数でテンプレート展開 | E-02 行275-310 | ○ |
| C-08 | catalog.sItemViewをテンプレートとして使用 | E-02 行276 `sFicheITEMVIEW=catalog.sItemView` | ○ |
| C-09 | {ITEMTITLE}プレースホルダ置換 | E-02 行277 `replace(sFicheITEMVIEW,"{ITEMTITLE}",sanitize(sTitle),...)` | ○ |
| C-10 | {ITEMDATE}プレースホルダ置換 | E-02 行278 `replace(sFicheITEMVIEW,"{ITEMDATE}",convertEuroDate(dDate),...)` | ○ |
| C-11 | {ITEMPICTURE}プレースホルダ置換 | E-02 行279 `replace(sFicheITEMVIEW,"{ITEMPICTURE}",picURL,...)` | ○ |
| C-12 | {ITEMENCID}プレースホルダ置換 | E-02 行280 `replace(sFicheITEMVIEW,"{ITEMENCID}",encrypt(iId),...)` | ○ |
| C-13 | treatConstantsで定数展開 | E-02 行281 `sFicheITEMVIEW=treatConstants(sFicheITEMVIEW,true)` | ○ |
| C-14 | カスタムフィールドのプレースホルダ置換 | E-02 行283-296 ループ処理 | ○ |
| C-15 | ファイルタイプのプレースホルダ置換 | E-02 行298-308 ループ処理 | ○ |
| C-16 | checkOnlineでセキュリティチェック | E-02 行371-384 | ○ |
| C-17 | iId空の場合リダイレクト | E-02 行372-374 `if isLeeg(iId) then Response.Redirect` | ○ |
| C-18 | 顧客ID不一致でリダイレクト | E-02 行375-377 `if convertGetal(catalog.iCustomerID)<>convertGetal(cId)` | ○ |
| C-19 | bForm=falseでリダイレクト | E-02 行378-380 `if not bForm then Response.Redirect` | ○ |
| C-20 | sSeoTitleプロパティでSEO用タイトル生成 | E-02 行407-409 `sSeoTitle=quotrep(treatConstants(...))` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのClaimに根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: プレースホルダのXSS対策（sanitize関数の使用）
- 0: 暗号化IDの復号化失敗時の挙動
- 0: テンプレートが未設定（sItemViewが空）の場合の表示

## 6) レビュアーチェックリスト（最小）
- [ ] E-02 行277でのsanitize関数がXSS対策として十分か確認
- [ ] E-02 行11-13の自動初期化がパフォーマンスに問題ないか確認
- [ ] checkOnlineがdefault.aspから適切に呼び出されているか確認
- [ ] sItemViewテンプレートが未設定の場合のフォールバック処理を確認
