---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：174-投稿表示処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **iSearchTypeの完全な定義**：値と意味の対応表確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_showpost.asp` 行1-6
- E-02: `asp/includes/post.asp` 行1-878
- E-03: `asp/includes/theme.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行215-216
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行175

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cls_postオブジェクトを生成 | E-01 行3 `set showPost=new cls_post` | ○ |
| C-02 | buildShortPost()で投稿表示HTML生成 | E-01 行4 `pageBody=showPost.buildShortPost()` | ○ |
| C-03 | pageTitleに投稿タイトル設定 | E-01 行5 `pageTitle=quotrep(replace(showPost.sSubject,...))` | ○ |
| C-04 | "["を"|R|R|R|"に置換 | E-01 行5 `replace(showPost.sSubject,"[","\|R\|R\|R\|",1,-1,1)` | ○ |
| C-05 | sSEOTitleにpageTitleを設定 | E-01 行6 `selectedPage.sSEOTitle=pageTitle` | ○ |
| C-06 | Class_InitializeでリクエストからiPostIDを取得 | E-02 行12-13 `pick(decrypt(request("iPostID")))` | ○ |
| C-07 | pick関数でDBから投稿情報取得 | E-02 行15-55 | ○ |
| C-08 | Applicationキャッシュを使用 | E-02 行18-37 `Application("POST"&id)` | ○ |
| C-09 | buildShortPost関数で表示生成 | E-02 行273-355 | ○ |
| C-10 | iSearchType=0でホームページリダイレクト | E-02 行276-277 `if theme.iSearchType=0 then redirectToHP()` | ○ |
| C-11 | iSearchType=2かつ未認証でリダイレクト | E-02 行278-279 `elseif theme.iSearchType=2 and not logon.authenticatedIntranet` | ○ |
| C-12 | bNeedsToBeValidatedでリダイレクト | E-02 行280-281 `elseif bNeedsToBeValidated then redirectToHP()` | ○ |
| C-13 | QS_theme DIVでHTML構造生成 | E-02 行283 `buildShortPost="<div id='QS_theme'..."` | ○ |
| C-14 | bAllowHTMLでHTML/プレーンテキスト分岐 | E-02 行298-307 `if theme.bAllowHTML then...else` | ○ |
| C-15 | sFileLinkで添付ファイル表示 | E-02 行308 `buildShortPost=buildShortPost&sFileLink(...)` | ○ |
| C-16 | formatTimeStampで日時フォーマット | E-02 行309 `formatTimeStamp(dUpdatedTS)` | ○ |
| C-17 | contact.sClickNickNameで投稿者表示 | E-02 行309 `contact.sClickNickName` | ○ |
| C-18 | replies関数で返信一覧取得 | E-02 行313, 700-718 | ○ |
| C-19 | customer.bUseAvatarsでアバター表示制御 | E-02 行304-305 `if customer.bUseAvatars then` | ○ |
| C-20 | addSmiliesでスマイリー変換 | E-02 行306 `addSmilies(linkUrls(quotrep(sBody)))` | ○ |
| C-21 | 行354で特殊文字置換 | E-02 行354 `replace(buildShortPost,"[","\|R\|R\|R\|",1,-1,1)` | ○ |
| C-22 | iSearchTypeの値と意味の完全な定義 | **根拠なし**（theme.aspでの定数定義未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- iSearchTypeの完全な値定義
  - 候補：theme.aspの定数定義 / constants.aspの定義 / データベーススキーマ

## 5) リスクフラグ（レビュー観点）
- 0: XSS対策（quotrep, addSmilies, linkUrlsの連携）
- 1: Applicationキャッシュのメモリ使用量
- 0: 特殊文字置換（"|R|R|R|"）の逆変換処理

## 6) レビュアーチェックリスト（最小）
- [ ] E-02 行276-281のセキュリティチェックが全ケースを網羅しているか確認
- [ ] Applicationキャッシュのクリア処理が適切に実装されているか確認
- [ ] sFileLink関数のファイルタイプチェックがセキュリティ上適切か確認
- [ ] 返信一覧のネスト深度に制限があるか確認
