---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：175-ページ編集（FS）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **getTper/getBperの詳細な権限設定方法**：バックサイトでの権限付与フローの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/fs_editPage.asp` 行1-68
- E-02: `asp/includes/contact.asp`（インクルードファイル参照）
- E-03: `asp/includes/page.asp`（インクルードファイル参照）
- E-04: `asp/includes/mail_message.asp`（インクルードファイル参照）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行216
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 行176

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | begin.aspをインクルード | E-01 行1 `<!-- #include file="begin.asp"-->` | ○ |
| C-02 | pagetoemail/editPageフラグ設定 | E-01 行4-5 `pagetoemail=true editPage=true` | ○ |
| C-03 | getTper/getBper権限Dictionary取得 | E-01 行11-12 `set getTperP=logon.contact.getTper` | ○ |
| C-04 | createUserFilesFolder呼び出し | E-01 行14 `logon.contact.createUserFilesFolder()` | ○ |
| C-05 | postback判定でPOST処理分岐 | E-01 行15 `if convertBool(Request.Form ("postback")) then` | ○ |
| C-06 | checkCSRF()でCSRF検証 | E-01 行16 `checkCSRF()` | ○ |
| C-07 | getTper権限時にsTitle/sTitleToBeValidated設定 | E-01 行17-22 | ○ |
| C-08 | sNotifValidate設定時に承認待ちフィールド使用 | E-01 行18-19,25-27 `if not isLeeg(customer.sNotifValidate)` | ○ |
| C-09 | getBper権限時にsValue/sValueToBeValidated設定 | E-01 行24-32 | ○ |
| C-10 | sExternalURLPrefix/sExternalURL/bOpenInNewWindow設定 | E-01 行30-32 | ○ |
| C-11 | selectedPage.Save()で保存 | E-01 行36 `if selectedPage.Save then` | ○ |
| C-12 | 保存成功時にfb_saveOKメッセージ追加 | E-01 行37 `message.Add("fb_saveOK")` | ○ |
| C-13 | 承認待ち時にiUpdatedBy/dUpdatedOn設定 | E-01 行41-42 | ○ |
| C-14 | cls_mail_messageで通知メール送信 | E-01 行44-49 | ○ |
| C-15 | メール本文にログオン情報とページ情報を含む | E-01 行47 `logon.contact.sNickname...selectedPage.sTitle...` | ○ |
| C-16 | 承認待ち値を優先表示 | E-01 行55-59 | ○ |
| C-17 | フォームaction="fs_editPage.asp" | E-01 行60 `<form method="post" action="fs_editPage.asp"...>` | ○ |
| C-18 | QS_secCodeHiddenでCSRFトークン出力 | E-01 行60 `<%=QS_secCodeHidden%>` | ○ |
| C-19 | getTper権限時にタイトル入力欄表示 | E-01 行60 `if getTPerP.exists(selectedPage.iId) then` | ○ |
| C-20 | getBper権限時に外部URL設定表示（sExternalURLあり時） | E-01 行63-65 `if not isLeeg(selectedPage.sExternalURL)` | ○ |
| C-21 | createFCKInstanceでWYSIWYGエディタ生成 | E-01 行65 `createFCKInstance selectedPage.sValue,"siteBuilder","sValue"` | ○ |
| C-22 | bContainerPage時はWYSIWYGエディタ非表示 | E-01 行65 `elseif not convertBool(selectedPage.bContainerPage)` | ○ |
| C-23 | message.showAlert()でフィードバック表示 | E-01 行67 `<%=message.showAlert()%>` | ○ |
| C-24 | accessToEP=falseでnoaccess.htmへリダイレクト | E-01 行68 `if not accessToEP then Response.Redirect ("asp/noaccess.htm")` | ○ |
| C-25 | 主機能は「ページ作成・編集」（機能No.9） | E-05 | ○ |
| C-26 | getTper/getBperの詳細な権限設定方法 | **根拠なし**（contact.aspでの設定ロジック未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- getTper/getBper権限の詳細な設定方法
  - 候補：contact.aspのgetTper/getBperプロパティ定義 / バックサイトの権限設定画面 / tblContactの権限カラム

## 5) リスクフラグ（レビュー観点）
- 1: 承認待ちワークフローの完全性（承認/却下フロー）
- 0: WYSIWYGエディタのXSS対策
- 0: CSRFトークンの有効期限管理

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 行16のcheckCSRF関数がセッションハイジャック対策として十分か確認
- [ ] 承認待ちコンテンツの承認/却下フローがバックサイトに実装されているか確認
- [ ] WYSIWYGエディタ（FCKEditor/CKEditor）のセキュリティ設定を確認
- [ ] 通知メールの送信先（sNotifValidate）の設定方法を確認
