---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：176-リストページ編集（FS）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全てのClaimに根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/fs_editListPage.asp` 行1-39
- E-02: `asp/includes/page.asp`（インクルードファイル参照）
- E-03: `asp/includes/orderBYlist.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行217
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行177

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | begin.aspをインクルード | E-01 行1 `<!-- #include file="begin.asp"-->` | ○ |
| C-02 | pagetoemail/editPageフラグ設定 | E-01 行4-5 `pagetoemail=true editPage=true` | ○ |
| C-03 | getTper/getBper権限Dictionary取得 | E-01 行11-12 `set getTperP=logon.contact.getTper` | ○ |
| C-04 | createUserFilesFolder呼び出し | E-01 行14 `logon.contact.createUserFilesFolder()` | ○ |
| C-05 | postback判定でPOST処理分岐 | E-01 行15 `if convertBool(Request.Form ("postback")) then` | ○ |
| C-06 | checkCSRF()でCSRF検証 | E-01 行16 `checkCSRF()` | ○ |
| C-07 | getTper権限時にsTitle設定 | E-01 行17-19 `if getTPerP.exists(selectedPage.iId) then selectedPage.sTitle=...` | ○ |
| C-08 | getBper権限時にsValue設定 | E-01 行21 `selectedPage.sValue=convertStr(Request.Form("sValue"))` | ○ |
| C-09 | getBper権限時にbOpenOnload設定 | E-01 行22 `selectedPage.bOpenOnload=convertBool(Request.Form("bOpenOnload"))` | ○ |
| C-10 | getBper権限時にsOrderBY設定 | E-01 行23 `selectedPage.sOrderBY=convertStr(Request.Form("sOrderBY"))` | ○ |
| C-11 | getBper権限時にbPushRSS設定 | E-01 行24 `selectedPage.bPushRSS=convertBool(Request.Form("bPushRSS"))` | ○ |
| C-12 | getBper権限時にiLPOpenByDefault設定 | E-01 行25 `selectedPage.iLPOpenByDefault=convertGetal(Request.Form("iLPOpenByDefault"))` | ○ |
| C-13 | selectedPage.Save()で保存 | E-01 行28 `if selectedPage.Save then` | ○ |
| C-14 | 保存成功時にfb_saveOKメッセージ追加 | E-01 行29 `message.Add("fb_saveOK")` | ○ |
| C-15 | cls_orderByListオブジェクト生成 | E-01 行34-35 `set orderByList=new cls_orderByList` | ○ |
| C-16 | フォームaction="fs_editListPage.asp" | E-01 行35 `<form method="post" action="fs_editListPage.asp"...>` | ○ |
| C-17 | QS_secCodeHiddenでCSRFトークン出力 | E-01 行35 `<%=QS_secCodeHidden%>` | ○ |
| C-18 | getTper権限時にタイトル入力欄表示 | E-01 行35-36 `if getTPerP.exists(selectedPage.iId) then` | ○ |
| C-19 | orderByList.showSelectedでソート順選択肢表示 | E-01 行37 `orderByList.showSelected("option",selectedPage.sOrderBy)` | ○ |
| C-20 | numberListで初期展開数選択肢生成 | E-01 行37 `numberList(0,20,1,selectedPage.iLPOpenByDefault)` | ○ |
| C-21 | createFCKInstanceでWYSIWYGエディタ生成 | E-01 行37 `createFCKInstance selectedPage.sValue,"siteBuilder","sValue"` | ○ |
| C-22 | 主機能は「リストページ管理」（機能No.13） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのClaimに根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: ソート順の有効値チェック
- 0: iLPOpenByDefaultの範囲チェック（0-20）
- 0: bPushRSSとRSSフィード生成の連携

## 6) レビュアーチェックリスト（最小）
- [ ] sOrderBYの有効値がcls_orderByListで正しく定義されているか確認
- [ ] iLPOpenByDefaultの値が0-20の範囲外でも問題ないか確認
- [ ] bPushRSS=trueの場合のRSSフィード生成ロジックを確認
- [ ] bOpenOnload=trueの場合、iLPOpenByDefault設定が無視されることを確認
