---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：177-リストアイテム編集（FS）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **deleteListItems関数の詳細実装**：子アイテム削除の完全なロジック確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/fs_editListItem.asp` 行1-62
- E-02: `asp/includes/page.asp`（インクルードファイル参照）
- E-03: `asp/includes/contact.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行218
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行178

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | begin.aspをインクルード | E-01 行1 `<!-- #include file="begin.asp"-->` | ○ |
| C-02 | pagetoemail/editPageフラグ設定 | E-01 行4-5 `pagetoemail=true editPage=true` | ○ |
| C-03 | getLper権限Dictionary取得 | E-01 行11-12 `set getLperP=logon.contact.getLper` | ○ |
| C-04 | iListPageIDの取得と設定 | E-01 行13-18 | ○ |
| C-05 | 権限なし時noaccess.htmへリダイレクト | E-01 行19 `if not getLperP.exists(iLPID) then Response.Redirect` | ○ |
| C-06 | btnaction=save_listitemで保存処理分岐 | E-01 行21 `if Request.Form("btnaction")=save_listitem then` | ○ |
| C-07 | sTitle設定 | E-01 行22 `selectedPage.sTitle=convertStr(Request.Form("sTitle"))` | ○ |
| C-08 | dPage設定（日付変換） | E-01 行23 `selectedPage.dPage=convertDateFromPicker(Request.Form("dPage"))` | ○ |
| C-09 | dOnlineFrom設定 | E-01 行24 `selectedPage.dOnlineFrom=convertDateFromPicker(...)` | ○ |
| C-10 | dOnlineUntill設定 | E-01 行25 `selectedPage.dOnlineUntill=convertDateFromPicker(...)` | ○ |
| C-11 | sLPExternalURL設定 | E-01 行26 `selectedPage.sLPExternalURL=convertStr(...)` | ○ |
| C-12 | bLPExternalOINW設定 | E-01 行27 `selectedPage.bLPExternalOINW=convertBool(...)` | ○ |
| C-13 | sValue設定 | E-01 行28 `selectedPage.sValue=convertStr(...)` | ○ |
| C-14 | sUserFriendlyURL設定 | E-01 行29 `selectedPage.sUserFriendlyURL=convertStr(...)` | ○ |
| C-15 | iListPageID設定 | E-01 行30 `selectedPage.iListPageID=convertGetal(decrypt(...))` | ○ |
| C-16 | bLossePagina=false固定 | E-01 行31 `selectedPage.bLossePagina=false` | ○ |
| C-17 | bOnline=false固定 | E-01 行32 `selectedPage.bOnline=false` | ○ |
| C-18 | actionBtn=deleteで削除処理分岐 | E-01 行33 `if Request.Form("actionBtn")=l("delete") then` | ○ |
| C-19 | 削除時bDeleted=true | E-01 行34 `selectedPage.bDeleted=true` | ○ |
| C-20 | 削除時parentPage.removeRang呼び出し | E-01 行35 `selectedPage.parentPage.removeRang(selectedPage)` | ○ |
| C-21 | 削除時iRang=0設定 | E-01 行36 `selectedPage.iRang=0` | ○ |
| C-22 | 削除時bOnline=false, bHomepage=false | E-01 行37-38 | ○ |
| C-23 | 削除時deleteListItems呼び出し | E-01 行39 `selectedPage.deleteListItems()` | ○ |
| C-24 | save()成功時fs_editListItems.aspへリダイレクト | E-01 行41-42 `if selectedPage.save then Response.Redirect` | ○ |
| C-25 | JQDatePickerで日付入力 | E-01 行50-51 `JQDatePicker("dPage")` etc. | ○ |
| C-26 | customer.bUserFriendlyURLで表示制御 | E-01 行53-57 `if convertBool(customer.bUserFriendlyURL)` | ○ |
| C-27 | createFCKInstanceでWYSIWYGエディタ生成 | E-01 行61 `createFCKInstance selectedPage.sValue,"siteBuilder","sValue"` | ○ |
| C-28 | deleteListItems関数の詳細実装 | **根拠なし**（page.aspでの実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- deleteListItems関数の詳細実装
  - 候補：page.aspのdeleteListItemsメソッド / 子アイテム削除のカスケードロジック

## 5) リスクフラグ（レビュー観点）
- 1: 削除処理のカスケード（子アイテム、添付ファイル等）
- 0: 日付変換（convertDateFromPicker）の国際化対応
- 0: 外部URL表示条件の複雑さによるバグリスク

## 6) レビュアーチェックリスト（最小）
- [ ] deleteListItems関数が子アイテムを完全に削除しているか確認
- [ ] 削除時の確認ダイアログがJavaScriptで正しく実装されているか確認
- [ ] 日付入力のバリデーションが適切か確認
- [ ] 外部URL表示条件（行60）の複合条件が正しいか確認
