---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：178-リストアイテム一覧（FS）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全てのClaimに根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/fs_editListItems.asp` 行1-50
- E-02: `asp/includes/page.asp`（インクルードファイル参照）
- E-03: `asp/includes/contact.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行219
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行179

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | begin.aspをインクルード | E-01 行1 `<!-- #include file="begin.asp"-->` | ○ |
| C-02 | pagetoemail/editPageフラグ設定 | E-01 行2-3 `pagetoemail=true editPage=true` | ○ |
| C-03 | getLper権限Dictionary取得 | E-01 行4-5 `set getLperP=logon.contact.getLper` | ○ |
| C-04 | 権限なし時noaccess.htmへリダイレクト | E-01 行7 `if not getLperP.exists(selectedPage.iId) then Response.Redirect` | ○ |
| C-05 | listitems(false)でアイテム取得 | E-01 行14 `set listitems=selectedPage.listitems(false)` | ○ |
| C-06 | リストページタイトル表示 | E-01 行17 `<%=l("managelist")%>: '<b><%=selectedPage.sTitle%></b>'` | ○ |
| C-07 | 新規アイテム追加フォーム | E-01 行18-21 `<form action="fs_editListItem.asp" method="post">` | ○ |
| C-08 | iListPageIDをhiddenで送信 | E-01 行19 `<input type="hidden" name="iListPageID" value="<%=encrypt(selectedPage.iID)%>" />` | ○ |
| C-09 | addnewitemボタン表示 | E-01 行20 `<input type="submit" class="art-button" value="<%=l("addnewitem")%>" />` | ○ |
| C-10 | listitems.count>0でアイテム表示分岐 | E-01 行24 `<%if listitems.count>0 then%>` | ○ |
| C-11 | For Each itemでループ表示 | E-01 行27 `for each item in listitems` | ○ |
| C-12 | オフライン時イタリック表示 | E-01 行29-30 `if listitems(item).statusString=l("offline") then Response.Write "<li style=""margin:6px""><i>Offline:` | ○ |
| C-13 | タイトルリンク（編集画面へ） | E-01 行30,32 `<a href=""fs_editListItem.asp?iId="& encrypt(item) & """>"` | ○ |
| C-14 | オンライン時のみプレビューリンク | E-01 行35-37 `if listitems(item).statusString<>l("offline") then Response.Write "&nbsp;-&nbsp;<a target=""_blank""` | ○ |
| C-15 | プレビューURLにitem/アンカー設定 | E-01 行36 `&amp;item=" & encrypt(item) & "#" & encrypt(item)` | ○ |
| C-16 | bListItemPic時に画像設定リンク | E-01 行39-41 `if convertBool(customer.bListItemPic) then response.write "&nbsp;-&nbsp;<a href=""fs_editListItemPic.asp` | ○ |
| C-17 | cleanUPASPで終了処理 | E-01 行50 `<%cleanUPASP%>` | ○ |
| C-18 | 主機能は「リストページ管理」（機能No.13） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのClaimに根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: listitems(false)の戻り値がDictionaryであることの確認
- 0: statusStringプロパティの実装確認
- 0: bListItemPic設定の有効範囲確認

## 6) レビュアーチェックリスト（最小）
- [ ] listitems(false)がオフラインアイテムも含めて正しく取得しているか確認
- [ ] statusStringプロパティがbOnline/bDeletedを正しく反映しているか確認
- [ ] encrypt/decrypt関数のセキュリティ強度を確認
- [ ] bListItemPic設定がcustomerオブジェクトで正しく管理されているか確認
