---
generated_at: 2026-01-23 11:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-全体パスワード適用

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **applyTotalPW()の実装詳細**：全ページへの一括適用処理の確認
  2. **removeTotalPW()の実装詳細**：全ページからのパスワード削除処理の確認
  3. **セカンドアドミン判定ロジック**：logon.currentPWによる判定の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_applyTotalPW.asp` - メイン画面ソースコード
- E-02: `asp/bs_process.asp` - パスワード処理（行157-184）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.18は全体パスワード適用画面である | E-03 | ○ |
| C-02 | URLパスはasp/bs_applyTotalPW.aspである | E-01, E-03 | ○ |
| C-03 | secondAdmin.bPagesPWで権限制御 | E-01 | ○ |
| C-04 | サイト全体パスワードはsTotalPWに保存 | E-01 | ○ |
| C-05 | パスワード最大15文字 | E-01 (maxlength=15) | ○ |
| C-06 | confirm()で確認ダイアログ表示 | E-01 (onclick属性) | ○ |
| C-07 | sTotalPW設定済みで削除ボタン表示 | E-01 | ○ |
| C-08 | save_pw_totalでパスワード保存 | E-02 (行162-166) | ○ |
| C-09 | customer.applyTotalPW()呼び出し | E-02 (行164) | ○ |
| C-10 | delete_pw_totalでパスワード削除 | E-02 (行157-161) | ○ |
| C-11 | customer.removeTotalPW()呼び出し | E-02 (行159) | ○ |
| C-12 | checkCSRF()でトークン検証 | E-02 | ○ |
| C-13 | セカンドアドミン判定でPW変更フォーム表示 | E-01 | ○ |
| C-14 | logon.currentPWで判定 | E-01 | ○ |
| C-15 | cSaveAdminPWで管理者PW保存 | E-02 (行176-184) | ○ |
| C-16 | パスワード一致チェック | E-02 (行177-178) | ○ |
| C-17 | pwnomatchエラーメッセージ | E-02 (行183) | ○ |
| C-18 | customer.saveAdminPW()呼び出し | E-02 (行179) | ○ |
| C-19 | 関連機能はパスワード変更(No.4) | E-04 | ○ |
| C-20 | bs_secondAdmin.aspへのリンク | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して根拠が確認できた
- 1: 中リスク - applyTotalPW()の全ページ一括更新の性能影響確認推奨
- 1: 中リスク - パスワードの暗号化/平文保存の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] サイト全体パスワード設定後、全ページにパスワードが適用されることを確認
- [ ] サイト全体パスワード削除後、全ページのパスワードがクリアされることを確認
- [ ] セカンドアドミンでログイン時にバックサイトPW変更フォームが表示されることを確認
- [ ] パスワード不一致時にエラーメッセージが表示されることを確認
- [ ] confirm()ダイアログでキャンセル時に処理が中止されることを確認
