---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：180-メール連絡先（FS）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全てのClaimに根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/fs_mailcontact.asp` 行1-33
- E-02: `asp/includes/contact.asp`（インクルードファイル参照）
- E-03: `asp/includes/mail_message.asp`（インクルードファイル参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行221
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行181

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | begin.aspをインクルード | E-01 行1 `<!-- #include file="begin.asp"-->` | ○ |
| C-02 | cls_contactオブジェクト生成 | E-01 行4-5 `dim contact set contact=new cls_contact` | ○ |
| C-03 | イントラネット未認証時Response.End | E-01 行6 `if not logon.authenticatedIntranet then Response.End` | ○ |
| C-04 | bGetEmailsFromSite=false時Response.End | E-01 行7 `if not contact.bGetEmailsFromSite then Response.End` | ○ |
| C-05 | postback判定でPOST処理分岐 | E-01 行8 `if convertBool(Request.Form ("postback")) then` | ○ |
| C-06 | CAPTCHAバリデーション（session比較） | E-01 行9 `If LCase(session("CAPTCHA")) <> LCase(Left(Request.Form("CAPTCHA"),4)) Then` | ○ |
| C-07 | CAPTCHA不一致時err_captchaエラー | E-01 行10 `message.AddError("err_captcha")` | ○ |
| C-08 | 本文空時err_mandatoryエラー | E-01 行11-12 `elseif isLeeg(Request.Form ("body")) then message.AddError("err_mandatory")` | ○ |
| C-09 | cls_mail_messageオブジェクト生成 | E-01 行14-15 `dim myMail set myMail=new cls_mail_message` | ○ |
| C-10 | receiver=contact.sEmail | E-01 行16 `myMail.receiver=contact.sEmail` | ○ |
| C-11 | receiverName=contact.sNickName | E-01 行17 `myMail.receiverName=contact.sNickName` | ○ |
| C-12 | subject設定（送信者ニックネーム含む） | E-01 行18 `myMail.subject="Private message from " & logon.contact.sNickName & " (" & customer.surl & ")"` | ○ |
| C-13 | body=linkURLS(Request.Form("body")) | E-01 行19 `myMail.body=linkURLS(Request.Form ("body"))` | ○ |
| C-14 | fromemail=logon.contact.sEmail | E-01 行20 `myMail.fromemail=logon.contact.sEmail` | ○ |
| C-15 | fromname=logon.contact.sNickName | E-01 行21 `myMail.fromname=logon.contact.sNickName` | ○ |
| C-16 | myMail.send実行 | E-01 行22 `myMail.send` | ○ |
| C-17 | CC送信チェック判定 | E-01 行24 `if convertBool(Request.Form ("cc")) then` | ○ |
| C-18 | CC時receiver=logon.contact.sEmail | E-01 行25 `myMail.receiver=logon.contact.sEmail` | ○ |
| C-19 | CC時receiverName=logon.contact.sNickName | E-01 行26 `myMail.receiverName=logon.contact.sNickName` | ○ |
| C-20 | CC時myMail.send実行（2回目） | E-01 行27 `myMail.send` | ○ |
| C-21 | 送信成功時mailsent=trueでリダイレクト | E-01 行30 `Response.Redirect ("fs_mailcontact.asp?mailsent=true&iContactID=" & encrypt(contact.iId))` | ○ |
| C-22 | mailsent=true時fb_mailsentメッセージ表示 | E-01 行32 `if Request.QueryString ("mailsent")="true" then%><p align="center"><%=l("fb_mailsent")%>` | ○ |
| C-23 | sendprivatemessageでNICKNAME置換表示 | E-01 行32 `replace(l("sendprivatemessage"),"[NICKNAME]","<b>"& contact.sNickName &"</b>"` | ○ |
| C-24 | CCチェックボックスデフォルトON | E-01 行32 `<input type="checkbox" name="cc" value="<%=true%>" checked />` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのClaimに根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: メール送信レート制限（スパム対策）
- 0: linkURLS関数のXSS対策
- 0: CAPTCHAのセキュリティ強度（4文字のみ）
- 0: メール内容のサニタイズ処理

## 6) レビュアーチェックリスト（最小）
- [ ] メール送信のレート制限が実装されているか確認
- [ ] linkURLS関数がXSS攻撃を防止しているか確認
- [ ] CAPTCHAの4文字チェックが十分なセキュリティを提供しているか確認
- [ ] cls_mail_messageのメール送信がSMTPインジェクションを防止しているか確認
- [ ] bGetEmailsFromSiteの設定がユーザーにより変更可能か確認
