---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：181-リストページ変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **データベース更新仕様**：遷移先での実際の更新処理の詳細確認が必要
  2. **多言語ラベル**：converttolistpageラベルの実際の値確認
  3. **権限制御の網羅性**：他の権限条件がないか確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_convertToListpage.asp` 2行目
- E-02: `asp/bs_editItem.asp` 16行目
- E-03: `asp/bs_editExternalURL.asp` 5行目
- E-04: `asp/bs_editList.asp` 全体
- E-05: `asp/bs_security.asp` 17-75行目
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 222行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リストページ変換リンクが表示される | E-01 | ○ |
| C-02 | 条件判定でisNumeriek(page.iId)を使用 | E-01 | ○ |
| C-03 | secondAdmin.bPageBody権限をチェック | E-01, E-05 | ○ |
| C-04 | bs_editItem.aspにインクルードされる | E-02 | ○ |
| C-05 | bs_editExternalURL.aspにインクルードされる | E-03 | ○ |
| C-06 | 遷移先はbs_editList.asp | E-01, E-04 | ○ |
| C-07 | ページIDは暗号化されて渡される | E-01 | ○ |
| C-08 | 多言語ラベルl("converttolistpage")を使用 | E-01 | ○ |
| C-09 | 機能No.9「ページ作成・編集」に関連 | E-06 | ○ |
| C-10 | リンクは中央揃えで表示 | E-01 | ○ |
| C-11 | 変換後、元のコンテンツは保持される | **根拠なし** | △ |
| C-12 | tblPageテーブルが更新される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-11「変換後、元のコンテンツは保持される」について
  - 理由：bs_editList.aspでの保存処理を詳細に追跡する必要があるが、ページのsValue（コンテンツ）が上書きされないことの直接的な根拠が確認できていない
  - 候補：bs_processPage.asp / page.asp save関数 / 実際の変換テスト

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：シンプルなリンク表示機能であり、データ更新は遷移先で行われる
- 1（中リスク）：変換後のデータ整合性は遷移先の実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコード2行目の条件式が正しく記載されているか確認
- [ ] bs_editList.aspでの変換処理が元のコンテンツを保持するか実際に確認
- [ ] 多言語ラベル「converttolistpage」の日本語訳を確認
- [ ] secondAdmin.bPageBody以外の権限条件がないか確認
