---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：182-外部URL変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **データベース更新仕様**：遷移先での実際の更新処理の詳細確認が必要
  2. **ホームページ制限の理由**：ビジネスロジックの妥当性確認
  3. **他のインクルード元**：bs_editContainer.asp以外でも使用されているか確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_convertToExternalURL.asp` 2行目
- E-02: `asp/bs_editContainer.asp` 4行目
- E-03: `asp/bs_editExternalURL.asp` 全体
- E-04: `asp/bs_security.asp` 17-75行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 223行目
- E-06: `asp/bs_editExternalURL.asp` 5行目（URLTypeList使用）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 外部URL変換リンクが表示される | E-01 | ○ |
| C-02 | 条件判定でisNumeriek(page.iID)を使用 | E-01 | ○ |
| C-03 | ホームページではないことをチェック（not page.bHomepage） | E-01 | ○ |
| C-04 | secondAdmin.bPageBody権限をチェック | E-01, E-04 | ○ |
| C-05 | bs_editContainer.aspにインクルードされる | E-02 | ○ |
| C-06 | 遷移先はbs_editExternalURL.asp | E-01, E-03 | ○ |
| C-07 | ページIDは暗号化されて渡される | E-01 | ○ |
| C-08 | 多言語ラベルl("convertToExternalURL")を使用 | E-01 | ○ |
| C-09 | 機能No.14「外部URL設定」に関連 | E-05 | ○ |
| C-10 | リンクは中央揃えで表示 | E-01 | ○ |
| C-11 | URLプレフィックス選択にURLTypeListを使用 | E-06 | ○ |
| C-12 | bOpenInNewWindowオプションがある | E-03 | ○ |
| C-13 | tblPageテーブルが更新される | E-03 | ○ |
| C-14 | ホームページは外部URLに変換不可の理由 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14「ホームページは外部URLに変換不可」について
  - 理由：コード上の条件（not page.bHomepage）は確認できるが、なぜホームページを除外する必要があるかのビジネスロジックの根拠が明示されていない
  - 候補：設計仕様書 / ビジネス要件定義書 / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：シンプルなリンク表示機能であり、データ更新は遷移先で行われる
- 1（中リスク）：ホームページの除外条件が適切かどうかの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコード2行目の条件式が正しく記載されているか確認
- [ ] ホームページを外部URLに変換できない理由がビジネス要件と整合しているか確認
- [ ] 多言語ラベル「convertToExternalURL」の日本語訳を確認
- [ ] bs_editItem.aspでもこのファイルがインクルードされているか確認
