---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：185-フリーページ変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **bCanBeConvertedToFPの判定ロジック**：どのような条件でtrueになるか確認
  2. **convertToFP()メソッドの詳細**：page.aspでの実装確認
  3. **CSRF対策の検証**：QS_secCodeURLの生成・検証ロジック確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_convertToFreePage.asp` 2行目
- E-02: `asp/bs_convertToFP.asp` 全体
- E-03: `asp/bs_process.asp` 6-16行目
- E-04: `asp/bs_editItem.asp` 16行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 226行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フリーページ変換リンクが表示される | E-01 | ○ |
| C-02 | 条件判定でpage.bCanBeConvertedToFPを使用 | E-01 | ○ |
| C-03 | 確認ダイアログが表示される | E-01 | ○ |
| C-04 | CSRFトークン（QS_secCodeURL）が付与される | E-01 | ○ |
| C-05 | btnaction=ConvertToFPで処理される | E-01, E-03 | ○ |
| C-06 | checkCSRF()が呼ばれる | E-03 | ○ |
| C-07 | page.convertToFP()が実行される | E-03 | ○ |
| C-08 | 成功時bs_default.aspにリダイレクト | E-03 | ○ |
| C-09 | イントラネットの場合bs_intranet.aspにリダイレクト | E-03 | ○ |
| C-10 | 失敗時err_mandatoryエラーが追加される | E-03 | ○ |
| C-11 | bs_editItem.aspにインクルードされる | E-04 | ○ |
| C-12 | 多言語ラベルl("converttofreepage")を使用 | E-01 | ○ |
| C-13 | 多言語ラベルl("areyousure")を確認ダイアログで使用 | E-01 | ○ |
| C-14 | 機能No.9「ページ作成・編集」に関連 | E-05 | ○ |
| C-15 | bLossePaginaフラグがtrueに設定される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15「bLossePaginaフラグがtrueに設定される」について
  - 理由：page.convertToFP()メソッドの実装詳細をpage.aspで確認する必要があるが、ファイルサイズが大きく全体を確認できていない
  - 候補：page.asp convertToFP関数 / 実際の変換テスト

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）：変換処理は確認ダイアログがあるが、元に戻す機能についての確認が必要
- 1（中リスク）：bCanBeConvertedToFPの判定ロジックが不明確

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコード2行目の条件式とリンク生成が正しく記載されているか確認
- [ ] page.convertToFP()メソッドの実装詳細を確認（bLossePaginaの設定）
- [ ] bCanBeConvertedToFPプロパティの判定ロジックを確認
- [ ] フリーページから通常ページへの逆変換が可能か確認
- [ ] 多言語ラベル「converttofreepage」「areyousure」の日本語訳を確認
