---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：186-FP変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **convertToFP()メソッドの実装**：page.aspでの詳細確認
  2. **cleanupASP()関数**：リソースクリーンアップの詳細確認
  3. **データベース更新項目**：iRangのクリア処理確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_convertToFP.asp` 全体（1-6行目）
- E-02: `asp/bs_process.asp` 6-16行目（ConvertToFPケース）
- E-03: `asp/bs_security.asp` 全体
- E-04: `asp/begin.asp` 全体
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 227行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | begin.aspをインクルードする | E-01 | ○ |
| C-02 | bs_security.aspをインクルードする | E-01 | ○ |
| C-03 | bs_process.aspをインクルードする | E-01 | ○ |
| C-04 | btnaction=ConvertToFPで処理される | E-02 | ○ |
| C-05 | checkCSRF()が呼ばれる | E-02 | ○ |
| C-06 | page.convertToFP()が実行される | E-02 | ○ |
| C-07 | 成功時bs_default.aspにリダイレクト | E-02 | ○ |
| C-08 | イントラネットの場合bs_intranet.aspにリダイレクト | E-02 | ○ |
| C-09 | 失敗時err_mandatoryエラーが追加される | E-02 | ○ |
| C-10 | message.showAlert()でメッセージ表示 | E-01 | ○ |
| C-11 | cleanupASP()でクリーンアップ | E-01 | ○ |
| C-12 | 機能No.9「ページ作成・編集」に関連 | E-05 | ○ |
| C-13 | UIを持たない処理専用ページ | E-01 | ○ |
| C-14 | iRangがnullにクリアされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14「iRangがnullにクリアされる」について
  - 理由：page.convertToFP()メソッドの実装詳細をpage.aspで確認する必要があるが、ファイルサイズが大きく全体を確認できていない
  - 候補：page.asp convertToFP関数 / 実際の変換テスト

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：シンプルなリダイレクト処理ファイル
- 1（中リスク）：convertToFP()の実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコード構造（インクルード順序）が正しく記載されているか確認
- [ ] E-02のConvertToFPケースの処理フローが正しく記載されているか確認
- [ ] page.convertToFP()メソッドの実装詳細を確認（iRang、iParentIDの処理）
- [ ] cleanupASP()関数の処理内容を確認
