---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：187-初期セットアップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **customer.reset()の詳細**：どのテーブルがリセットされるか確認
  2. **パスワード保存のセキュリティ**：SHA256のみか、ソルトの有無確認
  3. **デフォルトパスワードの定義**：QS_defaultPWの値確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_initialsetup.asp` 全体（45行）
- E-02: `asp/includes/customer.asp` 1-250行（pickメソッド、saveメソッド）
- E-03: `asp/bs_security.asp` 76-78行（デフォルトPWリダイレクト）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 228行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトパスワードでない場合bs_admin.aspにリダイレクト | E-01 | ○ |
| C-02 | btnaction=saveSetupAdminで処理される | E-01 | ○ |
| C-03 | checkCSRF()が呼ばれる | E-01 | ○ |
| C-04 | getRequestForm()でフォーム値取得 | E-01 | ○ |
| C-05 | 開始モード未選択でエラー | E-01 | ○ |
| C-06 | パスワード不一致でエラー | E-01 | ○ |
| C-07 | customer.save()で保存 | E-01 | ○ |
| C-08 | customer.saveAdminPW()でパスワード保存 | E-01 | ○ |
| C-09 | cleanモードでcustomer.reset()実行 | E-01 | ○ |
| C-10 | 成功時bs_default.aspにリダイレクト | E-01 | ○ |
| C-11 | パスワードはSHA256でハッシュ化 | E-02 | ○ |
| C-12 | languageListで言語選択 | E-01 | ○ |
| C-13 | dateFormatListで日付フォーマット選択 | E-01 | ○ |
| C-14 | 初期URLはサーバー変数から取得 | E-01 | ○ |
| C-15 | 確認ダイアログが表示される | E-01 | ○ |
| C-16 | 機能No.5「サイト基本設定」に関連 | E-04 | ○ |
| C-17 | bUseArtLoginTemplate=trueが設定される | E-01 | ○ |
| C-18 | customer.reset()で全テーブルがリセットされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18「customer.reset()で全テーブルがリセットされる」について
  - 理由：customer.aspのreset()メソッドの詳細を確認する必要があるが、ファイルが大きく全体を確認できていない
  - 候補：customer.asp reset関数（600行目付近） / 実際のリセットテスト

## 5) リスクフラグ（レビュー観点）
- 2（高リスク）："clean"モードは全データをリセットするため、誤操作に注意が必要
- 1（中リスク）：パスワードセキュリティ（ソルトの有無等）の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコード全体の処理フローが正しく記載されているか確認
- [ ] customer.reset()メソッドの詳細を確認（リセット対象テーブル）
- [ ] SHA256ハッシュ化の際にソルトが使用されているか確認
- [ ] デフォルトパスワード（QS_defaultPW）の定義場所と値を確認
- [ ] "clean"モード選択時の警告が十分か確認
