---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：188-コード編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ検証**：パス検証ロジックが十分か確認
  2. **CodeMirrorバージョン**：使用しているバージョンの確認
  3. **エンコーディング**：UTF-8以外のファイルの扱い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editcode.asp` 全体（179行）
- E-02: `asp/bs_editcode.asp` 3行目（セカンドアドミンチェック）
- E-03: `asp/bs_editcode.asp` 12-23行目（拡張子判定）
- E-04: `asp/bs_editcode.asp` 34-46行目（パス検証）
- E-05: `asp/bs_editcode.asp` 99-106行目（保存処理）
- E-06: `asp/bs_editcode.asp` 70-95行目（コピー処理）
- E-07: `asp/bs_editcode.asp` 155-173行目（CodeMirror設定）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 229行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セカンドアドミンはアクセス不可 | E-02 | ○ |
| C-02 | 許可拡張子はjs、html、htm、txt、css | E-03 | ○ |
| C-03 | モード判定でtext/javascript、text/html、text/cssを設定 | E-03 | ○ |
| C-04 | 不許可拡張子はresponse.endで終了 | E-03 | ○ |
| C-05 | ファイル存在確認（fso.fileexists） | E-04 | ○ |
| C-06 | ユーザーファイル領域外はアクセス不可 | E-04 | ○ |
| C-07 | btnAction=Saveでファイル保存 | E-05 | ○ |
| C-08 | FileSystemObjectで書き込み | E-05 | ○ |
| C-09 | copy=1でファイルコピー | E-06 | ○ |
| C-10 | コピー先に"- copy"を付与 | E-06 | ○ |
| C-11 | 同名ファイル存在時は連番付与 | E-06 | ○ |
| C-12 | CodeMirrorで行番号表示 | E-07 | ○ |
| C-13 | F11でフルスクリーン | E-07 | ○ |
| C-14 | Escでフルスクリーン解除 | E-07 | ○ |
| C-15 | lineWrappingオプション対応 | E-07, E-01 | ○ |
| C-16 | エディタサイズは100% x 520px | E-07 | ○ |
| C-17 | 保存完了で"file is saved"表示 | E-05 | ○ |
| C-18 | コピー完了で"file is copied"表示 | E-01 | ○ |
| C-19 | 機能No.96「スクリプト管理」に関連 | E-08 | ○ |
| C-20 | CodeMirrorのバージョン | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20「CodeMirrorのバージョン」について
  - 理由：codemirror.jsファイル自体を確認する必要があるが、ライブラリファイルの内容を確認していない
  - 候補：asp/codemirror/lib/codemirror.js / package.json（存在する場合）

## 5) リスクフラグ（レビュー観点）
- 2（高リスク）：ファイルシステムへの直接書き込みがあるため、パス検証のバイパス攻撃に注意
- 1（中リスク）：エンコーディング処理の確認が必要（UTF-8以外のファイル）
- 1（中リスク）：大きなファイルを開いた場合のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] E-04のパス検証ロジックがパストラバーサル攻撃を防止できるか確認
- [ ] C_VIRT_DIR & Application("QS_CMS_userfiles")の値と範囲を確認
- [ ] CodeMirrorのバージョンと既知の脆弱性を確認
- [ ] 大きなファイル（数MB以上）を開いた場合の動作確認
- [ ] エンコーディング（UTF-8以外）のファイルの扱いを確認
