---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：19-ページ検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **cls_contactクラスの定義**：メール送信先情報取得の詳細確認
  2. **cls_mail_messageクラスの定義**：メール送信処理の詳細確認
  3. **フロントサイト編集機能との連携**：検証待ちデータがどのように登録されるか

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_validatepage.asp` - メイン画面ソースコード
- E-02: `asp/includes/page.asp` - cls_pageクラス（sTitleToBeValidated、sValueToBeValidated定義）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.19はページ検証画面である | E-03 | ○ |
| C-02 | URLパスはasp/bs_validatepage.aspである | E-01, E-03 | ○ |
| C-03 | sTitleToBeValidatedで検証待ちタイトル管理 | E-01, E-02 | ○ |
| C-04 | sValueToBeValidatedで検証待ち本文管理 | E-01, E-02 | ○ |
| C-05 | タイトル承認でsTitle更新 | E-01 (行9-10) | ○ |
| C-06 | タイトル承認でsTitleToBeValidated=null | E-01 (行10) | ○ |
| C-07 | タイトル承認でsendMailToContact呼び出し | E-01 (行11) | ○ |
| C-08 | タイトル却下でsTitleToBeValidated=null | E-01 (行17) | ○ |
| C-09 | 本文承認でsValue更新 | E-01 (行21-22) | ○ |
| C-10 | 本文承認でsValueToBeValidated=null | E-01 (行22) | ○ |
| C-11 | 本文承認でsendMailToContact呼び出し | E-01 (行23) | ○ |
| C-12 | 本文却下でsValueToBeValidated=null | E-01 (行29) | ○ |
| C-13 | sendMailToContact関数定義 | E-01 (行33-44) | ○ |
| C-14 | cls_contact.pick呼び出し | E-01 (行35-36) | ○ |
| C-15 | cls_mail_message使用 | E-01 (行38-42) | ○ |
| C-16 | confirm()で確認ダイアログ | E-01 (行46-47) | ○ |
| C-17 | WYSIWYGエディタで本文編集 | E-01 (行47) | ○ |
| C-18 | 関連機能はページ検証(No.98) | E-04 | ○ |
| C-19 | cls_contactクラス定義ファイル | **根拠なし** | △ |
| C-20 | cls_mail_messageクラス定義ファイル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_contactクラスの定義ファイルが確認できていない
  - 候補：contact.asp / includes/contact.asp
- cls_mail_messageクラスの定義ファイルが確認できていない
  - 候補：mail_message.asp / includes/mail.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 検証処理の基本フローは明確に確認できた
- 1: 中リスク - メール送信処理の詳細確認推奨
- 1: 中リスク - フロントサイト編集でのsTitleToBeValidated/sValueToBeValidated登録処理の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] タイトル承認後、sTitleが更新されていることを確認
- [ ] 本文承認後、sValueが更新されていることを確認
- [ ] 承認時に更新者に通知メールが送信されることを確認
- [ ] 却下時に変更がキャンセルされることを確認
- [ ] フロントサイト編集から検証待ちデータが正しく登録されることを確認
