---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：190-ページ要素

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **遷移先画面の存在確認**：4つのリンク先ファイルの存在確認
  2. **bSetupPageElements権限**：secondAdminオブジェクトの権限設定確認
  3. **多言語対応**："Default Blocks"がハードコードされている点

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_pageelements.asp` 全体（37行）
- E-02: `asp/bs_pageelements.asp` 4行目（logon.hasaccess権限チェック）
- E-03: `asp/bs_pageelements.asp` 7-11行目（Bannersリンク）
- E-04: `asp/bs_pageelements.asp` 13-19行目（Default Blocksリンク）
- E-05: `asp/bs_pageelements.asp` 21-27行目（Footerリンク）
- E-06: `asp/bs_pageelements.asp` 29-34行目（Faviconリンク）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 231行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | logon.hasaccessでbSetupPageElements権限チェック | E-02 | ○ |
| C-02 | Bannersリンクはbs_editbannermenu.aspへ遷移 | E-03 | ○ |
| C-03 | view_column_2アイコンを使用（Banners） | E-03 | ○ |
| C-04 | Default Blocksリンクはbs_editProps.aspへ遷移 | E-04 | ○ |
| C-05 | flex_wrapアイコンを使用（Default Blocks） | E-04 | ○ |
| C-06 | "Default Blocks"はハードコード（多言語化されていない） | E-04 | ○ |
| C-07 | Footerリンクはbs_editfooter.aspへ遷移 | E-05 | ○ |
| C-08 | splitscreen_bottomアイコンを使用（Footer） | E-05 | ○ |
| C-09 | l("footer")で多言語対応 | E-05 | ○ |
| C-10 | Faviconリンクはbs_favicon.aspへ遷移 | E-06 | ○ |
| C-11 | wb_sunnyアイコンを使用（Favicon） | E-06 | ○ |
| C-12 | l("favicon")で多言語対応 | E-06 | ○ |
| C-13 | アイコンサイズは40px | E-03, E-04, E-05, E-06 | ○ |
| C-14 | material-symbols-outlinedクラスを使用 | E-03 | ○ |
| C-15 | テーブル幅450px、cellpadding=15 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
なし - すべての主張に根拠があります。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ナビゲーション画面のみでセキュリティリスクは極めて低い
- 0（低リスク）：データベース更新なし

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコード構造が正しく記載されているか確認
- [ ] 4つの遷移先ファイル（bs_editbannermenu.asp, bs_editProps.asp, bs_editfooter.asp, bs_favicon.asp）の存在確認
- [ ] secondAdmin.bSetupPageElements権限の定義と動作確認
- [ ] "Default Blocks"の多言語化対応が必要か検討
- [ ] Material Symbolsアイコンの読み込みが正常か確認
