---
generated_at: 2026-01-23 22:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：191-オンライン設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **子ページへの影響（C-12）**：親ページオフライン時の子ページ動作の詳細は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_onlineOrNot.asp` - 本画面のソースコード（9行）
- E-02: `asp/bs_security.asp` - セキュリティ・権限制御コード（79行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本画面は他画面への埋め込み部品として機能する | E-01 (インクルードファイルとして実装) | ○ |
| C-02 | secondAdmin.bPagePublish権限でUI表示を制御 | E-01 (2行目), E-02 (56行目) | ○ |
| C-03 | 親ページがオフラインの場合は設定変更不可 | E-01 (3行目: page.parentPage.bOnline判定) | ○ |
| C-04 | ホームページは非公開にできない | E-01 (3行目: page.canGoOffline判定) | ○ |
| C-05 | 子ページ存在時にオフラインにすると警告表示 | E-01 (6行目: subPages(true).count > 0でalert) | ○ |
| C-06 | bOnlineはcheckbox型の入力項目 | E-01 (3行目: input type=checkbox) | ○ |
| C-07 | 画面機能マッピングでページ一覧(8)・ページ作成編集(9)に関連 | E-04 (191行目) | ○ |
| C-08 | cannotgoofflineメッセージは親ページオフライン時に表示 | E-01 (3行目) | ○ |
| C-09 | cannotgoofflinehpメッセージはホームページ時に表示 | E-01 (3行目) | ○ |
| C-10 | warningofflineメッセージはJavaScript alertで表示 | E-01 (6行目) | ○ |
| C-11 | 親ページオフライン時はhiddenで値0固定 | E-01 (3行目: INPUT type="hidden" value="0") | ○ |
| C-12 | 親ページオフライン時は子ページもフロントサイトからアクセス不可 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 親ページオフライン時の子ページへの影響の詳細実装
  - 候補：`asp/includes/page.asp` / `default.asp`のページ表示ロジック / フロントエンド処理ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面はシンプルなUI部品であり、実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] bs_onlineOrNot.aspのソースコードが設計書と一致しているか確認
- [ ] secondAdmin.bPagePublish権限の設定箇所を確認
- [ ] 親ページオフライン時の子ページ表示動作を実機で確認
