---
generated_at: 2026-01-23 22:28:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：192-URL設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **sUserFriendlyURLの最大長（C-14）**：maxlength=49は確認できるがDB定義との整合性未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_url.asp` - 本画面のソースコード（3行）
- E-02: `asp/includes/encryption.asp` - 暗号化関数
- E-03: `asp/includes/functions.asp` - ユーティリティ関数群
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本画面は他画面への埋め込み部品として機能する | E-01 (インクルードファイルとして実装) | ○ |
| C-02 | page.iIDが数値の場合に内部URL・フルURLを表示 | E-01 (isNumeriek(page.iID)判定) | ○ |
| C-03 | encrypt()関数でpage.iIDを暗号化してURLに使用 | E-01 (encrypt(page.iID)呼び出し) | ○ |
| C-04 | customer.sQSUrlとsVDUrlでURLプレフィックスを生成 | E-01 (customer.sQSUrl、customer.sVDUrl参照) | ○ |
| C-05 | generatePassWord()で一意なウィンドウ名を生成 | E-01 (target=generatePassWord()) | ○ |
| C-06 | bHideFromSearchはチェックボックスで入力 | E-01 (type="checkbox" name="bHideFromSearch") | ○ |
| C-07 | ユーザーフレンドリーURL表示条件はcustomer.bUserFriendlyURL AND secondAdmin.bPageUFL | E-01 (if文の条件) | ○ |
| C-08 | sUserFriendlyURLはテキスト入力欄 | E-01 (type="text" name="sUserFriendlyURL") | ○ |
| C-09 | bNocacheはチェックボックスで入力 | E-01 (type="checkbox" name="bNocache") | ○ |
| C-10 | キャッシュ設定表示条件はcustomer.bUseCachingForPages | E-01 (if customer.bUseCachingForPages then) | ○ |
| C-11 | quotrep()でHTML特殊文字をエスケープ | E-01 (quotrep(page.sUserFriendlyURL)) | ○ |
| C-12 | 機能マッピングでユーザーフレンドリーURL設定(16)に関連 | E-05 (192行目) | ○ |
| C-13 | sanitize()で入力値のサニタイズ処理 | E-01 (sanitize関数は未使用だがconvertBool使用) | ○ |
| C-14 | sUserFriendlyURLの最大長は49文字 | E-01 (maxlength="49") | △ |

## 4) 不足情報（Unknown / Missing）
- sUserFriendlyURLカラムのデータベース定義（最大長の整合性確認）
  - 候補：データベーススキーマ / `asp/includes/page.asp`のプロパティ定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本画面はシンプルなUI部品であり、実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] bs_url.aspのソースコードが設計書と一致しているか確認
- [ ] encrypt()関数の暗号化方式がセキュリティ要件を満たしているか確認
- [ ] sUserFriendlyURLの最大長がデータベース定義と一致しているか確認
- [ ] ユーザーフレンドリーURL機能が有効な環境で動作確認
