---
generated_at: 2026-01-23 22:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：193-プロパティ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editProps.asp` - 本画面のソースコード（15行）
- E-02: `asp/bs_security.asp` - セキュリティ・権限制御コード
- E-03: `asp/bs_header.asp` - メニュー定義（461-463行でbs_editprops.aspへのリンク）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 8つのデフォルトブロック（PAGE_BLOCK01〜08）を編集 | E-01 (sProp01〜sProp08の処理) | ○ |
| C-02 | secondAdmin.bSetupPageElements権限でアクセス制御 | E-01 (4行目: logon.hasaccess secondAdmin.bSetupPageElements) | ○ |
| C-03 | CSRF検証を実施（checkCSRF()） | E-01 (5行目: checkCSRF()) | ○ |
| C-04 | 奇数番号ブロックはtextarea | E-01 (textarea name=sProp01, sProp03, sProp05, sProp07) | ○ |
| C-05 | 偶数番号ブロックはWYSIWYGエディタ | E-01 (createFCKInstance for sProp02, sProp04, sProp06, sProp08) | ○ |
| C-06 | removeEmptyP()で空段落を除去 | E-01 (6-13行目: removeEmptyP(convertStr(...))) | ○ |
| C-07 | customer.save()でデータベースに保存 | E-01 (14行目: if customer.save then) | ○ |
| C-08 | 保存成功時にメッセージ追加 | E-01 (14行目: message.Add("fb_saveOK")) | ○ |
| C-09 | quotrep()でHTMLエスケープ | E-01 (quotrep(customer.sProp01)等) | ○ |
| C-10 | Setup > Page elements > Default Blocksからアクセス | E-03 (461-463行目: bs_editprops.aspへのリンク) | ○ |
| C-11 | POSTメソッドで保存 | E-01 (form method="post") | ○ |
| C-12 | 機能マッピングでデフォルトブロック編集(21)に関連 | E-05 (193行目) | ○ |
| C-13 | textareaの幅は480px | E-01 (style="width:480px") | ○ |
| C-14 | QS_secCodeHiddenでCSRFトークン出力 | E-01 (QS_secCodeHidden) | ○ |
| C-15 | 説明テキストが画面上部に表示 | E-01 (p align="center" の説明文) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが完全に参照でき、すべての主張に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] bs_editProps.aspのソースコードが設計書と一致しているか確認
- [ ] createFCKInstance()関数の動作確認（WYSIWYGエディタ表示）
- [ ] customer.save()の保存処理が正常に動作するか確認
- [ ] テンプレートで[PAGE_BLOCK01]〜[PAGE_BLOCK08]が正しく展開されるか確認
