---
generated_at: 2026-01-23 22:36:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：194-ソート順設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_sortorder.asp` - 本画面のソースコード（11行）
- E-02: `asp/bs_security.asp` - セキュリティ・権限制御コード
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本画面は他画面への埋め込み部品として機能する | E-01 (インクルードファイルとして実装) | ○ |
| C-02 | bLossePaginaがtrueの場合は非表示 | E-01 (2行目: if not page.bLossePagina then) | ○ |
| C-03 | bPagesMoveとbPageOrderの両権限が必要 | E-01 (3行目: if secondAdmin.bPagesMove and secondAdmin.bPageOrder then) | ○ |
| C-04 | 新規ページ時はsibligs+1をデフォルト値とする | E-01 (6-7行目: pageRang=page.siblings+1) | ○ |
| C-05 | 既存ページ時はiRangをデフォルト値とする | E-01 (8-10行目: pageRang=page.iRang) | ○ |
| C-06 | numberList()関数で選択肢を生成 | E-01 (11行目: numberList(1,allRang,1,pageRang)) | ○ |
| C-07 | convertGetal()で数値変換 | E-01 (5行目: convertGetal(page.iId)) | ○ |
| C-08 | iRangはselectタグで入力 | E-01 (11行目: select name="iRang") | ○ |
| C-09 | l("placeinmenu")でラベル取得 | E-01 (11行目: l("placeinmenu")) | ○ |
| C-10 | 機能マッピングでページ移動・並び替え(11)に関連 | E-04 (194行目) | ○ |
| C-11 | 既存ページの場合allRangはsiblings | E-01 (10行目: allRang=page.siblings) | ○ |
| C-12 | 新規ページの場合allRangはsiblings+1 | E-01 (7行目: allRang=page.siblings+1) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが完全に参照でき、すべての主張に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] bs_sortorder.aspのソースコードが設計書と一致しているか確認
- [ ] page.siblingsプロパティの動作確認
- [ ] 並び順変更時に他ページのiRangが正しく再計算されるか確認
- [ ] ルートページで並び順設定が非表示になるか確認
