---
generated_at: 2026-01-23 22:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：195-リダイレクト先設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_redirectTO.asp` - 本画面のソースコード（2行）
- E-02: `asp/bs_security.asp` - セキュリティ・権限制御コード
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本画面は他画面への埋め込み部品として機能する | E-01 (インクルードファイルとして実装) | ○ |
| C-02 | secondAdmin.bPageRefresh権限で表示制御 | E-01 (if secondAdmin.bPageRefresh then) | ○ |
| C-03 | リダイレクト秒数は0〜600の範囲 | E-01 (numberList(0,600,1,page.iReload)) | ○ |
| C-04 | リダイレクト先URLの最大長は255文字 | E-01 (maxlength=255) | ○ |
| C-05 | iReloadはselectタグで入力 | E-01 (select name=iReload) | ○ |
| C-06 | sRedirectToはテキスト入力 | E-01 (input type=text name=sRedirectTo) | ○ |
| C-07 | quotRep()でHTML特殊文字をエスケープ | E-01 (quotRep(page.sRedirectTo)) | ○ |
| C-08 | l("refresh")、l("after")でラベル取得 | E-01 (l("refresh")、l("after")呼び出し) | ○ |
| C-09 | l("seconds")で単位ラベル取得 | E-01 (l("seconds")呼び出し) | ○ |
| C-10 | l("redirectto")でラベル取得 | E-01 (l("redirectto")呼び出し) | ○ |
| C-11 | 機能マッピングで外部URL設定(14)に関連 | E-04 (195行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが完全に参照でき、すべての主張に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] bs_redirectTO.aspのソースコードが設計書と一致しているか確認
- [ ] フロントエンドでmeta refreshタグが正しく出力されるか確認
- [ ] iReload=0の場合にリダイレクトが実行されないか確認
- [ ] 無効なURLを入力した場合の動作確認
