---
generated_at: 2026-01-23 22:44:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：196-メタタグ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_metatags.asp` - 本画面のソースコード（5行）
- E-02: `asp/bs_security.asp` - セキュリティ・権限制御コード
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本画面は他画面への埋め込み部品として機能する | E-01 (インクルードファイルとして実装) | ○ |
| C-02 | bPageTitleTag権限でTITLEタグ入力表示制御 | E-01 (if secondAdmin.bPageTitleTag then) | ○ |
| C-03 | bPageKeywords権限でキーワード入力表示制御 | E-01 (if secondAdmin.bPageKeywords then) | ○ |
| C-04 | bPageDescription権限で説明文入力表示制御 | E-01 (if secondAdmin.bPageDescription then) | ○ |
| C-05 | bPageAdditionalHeader権限で追加ヘッダー入力表示制御 | E-01 (if secondAdmin.bPageAdditionalHeader then) | ○ |
| C-06 | sSEOtitleの最大長は200文字 | E-01 (maxlength=200) | ○ |
| C-07 | sKeywordsの最大長は2048文字 | E-01 (maxlength=2048) | ○ |
| C-08 | sanitize()でXSS対策のサニタイズ処理 | E-01 (sanitize(page.sSEOtitle)等) | ○ |
| C-09 | quotRep()でHTML特殊文字のエスケープ処理 | E-01 (quotRep(page.sHeader)) | ○ |
| C-10 | sDescriptionはtextareaで入力 | E-01 (textarea name="sDescription") | ○ |
| C-11 | sHeaderはtextareaで入力 | E-01 (textarea name="sHeader") | ○ |
| C-12 | l("keywords")でラベル取得 | E-01 (l("keywords")呼び出し) | ○ |
| C-13 | l("description")でラベル取得 | E-01 (l("description")呼び出し) | ○ |
| C-14 | 機能マッピングでSEO設定(6)に関連 | E-04 (196行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが完全に参照でき、すべての主張に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] bs_metatags.aspのソースコードが設計書と一致しているか確認
- [ ] フロントエンドでMETAタグが正しく出力されるか確認
- [ ] sanitize()関数がXSS攻撃を適切に防御できるか確認
- [ ] 追加ヘッダーに危険なスクリプトが入力された場合の動作確認
