---
generated_at: 2026-01-23 22:48:00
metrics:
  claims_total: 6
  claims_with_evidence: 6
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：197-バックサイトエントリー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：6 / 6、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `backsite/default.asp` - 本画面のソースコード（3行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Response.Redirectでbs_login.aspへリダイレクト | E-01 (Response.Redirect ("../asp/bs_login.asp")) | ○ |
| C-02 | ファイルは3行で構成される | E-01 (1-3行目) | ○ |
| C-03 | 相対パス（../asp/）を使用 | E-01 ("../asp/bs_login.asp") | ○ |
| C-04 | ユーザー操作なしで自動処理される | E-01 (ASPコード実行で即リダイレクト) | ○ |
| C-05 | 機能マッピングで管理者ログイン(1)に関連 | E-03 (197行目) | ○ |
| C-06 | 画面遷移図でBACKSITE→BS_LOGINの遷移が定義 | E-04 (BACKSITE --> BS_LOGIN) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルなリダイレクト処理のみ

## 6) レビュアーチェックリスト（最小）
- [ ] backsite/default.aspのソースコードが設計書と一致しているか確認
- [ ] /backsite/へのアクセスで正しくログイン画面にリダイレクトされるか確認
- [ ] リダイレクト先のbs_login.aspが存在するか確認
