---
generated_at: 2026-01-23 22:52:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：198-ウェブ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/config/web_config.asp` - 本ファイルのソースコード（89行）
- E-02: `asp/begin.asp` - インクルード元ファイル
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C_VIRT_DIRは仮想ディレクトリパス定数 | E-01 (9行目) | ○ |
| C-02 | C_DIRECTORY_QUICKERSITEはQuickerSiteディレクトリパス | E-01 (10行目) | ○ |
| C-03 | QS_CMS_userfilesはアップロードファイル保存先 | E-01 (16行目) | ○ |
| C-04 | C_MAILCOMPONENTはデフォルトでcdo.message | E-01 (22行目) | ○ |
| C-05 | C_SMTPSERVERはデフォルトでlocalhost | E-01 (23行目) | ○ |
| C-06 | C_SMTPPORTはデフォルトで25 | E-01 (24行目) | ○ |
| C-07 | C_SENDUSINGはデフォルトで1（ローカル） | E-01 (34行目) | ○ |
| C-08 | QS_DBSはデフォルトで1（Access） | E-01 (40行目) | ○ |
| C-09 | C_DATABASEはserver.MapPathでパス生成 | E-01 (41行目) | ○ |
| C-10 | C_DATABASE_LABELSはQuickerLabels.mdb | E-01 (43行目) | ○ |
| C-11 | QS_CMS_iCustomerIDはデフォルトで73 | E-01 (62行目) | ○ |
| C-12 | C_ADMINEMAILはエラー転送先メール | E-01 (67行目) | ○ |
| C-13 | C_ADMINPASSWORDは管理者パスワード | E-01 (68行目) | ○ |
| C-14 | QS_admin_login_pageはad_login.asp | E-01 (69行目) | ○ |
| C-15 | execBeforePageLoadはページロード前実行ASP | E-01 (75行目) | ○ |
| C-16 | QS_number_of_allowed_attempts_to_loginはデフォルトで5 | E-01 (83行目) | ○ |
| C-17 | C_DEVはデフォルトでfalse | E-01 (85行目) | ○ |
| C-18 | begin.aspからweb_config.aspがインクルードされる | E-02 (57行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - セキュリティ関連の設定項目を含むため、設定値の適切性を確認

## 6) レビュアーチェックリスト（最小）
- [ ] web_config.aspのソースコードが設計書と一致しているか確認
- [ ] C_ADMINPASSWORDが適切に設定されているか確認
- [ ] データベースパス（C_DATABASE）が正しいか確認
- [ ] SMTPサーバー設定が環境に合っているか確認
- [ ] 本番環境でC_DEV=falseになっているか確認
