---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-管理者ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **web_config.aspのC_ADMINPASSWORD定義**：設定ファイルの内容確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_login.asp` 行1-21
- E-02: `asp/includes/logonEdit.asp` 行55-85
- E-03: `asp/ad_security.asp` 行1-3
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行3
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行5-6
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 行18-36

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/ad_login.asp である | E-04 | ○ |
| C-02 | CAPTCHA認証が必須である | E-01 行8-10, E-05 | ○ |
| C-03 | パスワードはEncrypt関数で暗号化される | E-01 行11 | ○ |
| C-04 | ログイン成功時はad_default.aspへリダイレクト | E-01 行12 | ○ |
| C-05 | ログイン試行回数がApplication変数で管理される | E-01 行16, E-02 行59 | ○ |
| C-06 | lockAdmin関数でIPブロックを実行 | E-01 行18, E-02 行68-85 | ○ |
| C-07 | QS_number_of_allowed_attempts_to_loginで試行上限を設定 | E-02 行74 | ○ |
| C-08 | btnaction値はloginAdmin | E-01 行7 | ○ |
| C-09 | CAPTCHAは大文字小文字を区別しない | E-01 行8（LCase使用） | ○ |
| C-10 | CAPTCHA入力は先頭4文字のみ検証される | E-01 行8（Left関数） | ○ |
| C-11 | C_ADMINPASSWORDと照合される | E-02 行57 | ○ |
| C-12 | SHA256でも検証可能 | E-02 行57 | ○ |
| C-13 | Session変数名はisAUTHENTICATEDasADMIN | E-02 行58 | ○ |
| C-14 | 認証成功時にApplication変数がリセットされる | E-02 行59 | ○ |
| C-15 | bUseArtLoginTemplateがtrue設定 | E-01 行4 | ○ |
| C-16 | err_captchaエラーコードが使用される | E-01 行10 | ○ |
| C-17 | err_loginエラーコードが使用される | E-01 行14 | ○ |
| C-18 | C_ADMINPASSWORDが空の場合、アクセス遮断 | E-02 行69-73 | ○ |
| C-19 | bs_endBack.aspでページが閉じられる | E-01 行20 | ○ |
| C-20 | bs_initBack.aspがインクルードされる | E-01 行20 | ○ |
| C-21 | タイトルは「ADMIN Login」 | E-01 行20 | ○ |
| C-22 | ブロック時にメール通知される | E-02 行77-80 | ○ |
| C-23 | 多言語対応されている（l関数使用） | E-01 行20 | ○ |
| C-24 | web_config.aspにC_ADMINPASSWORDが定義される | **未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- web_config.aspの実際の内容が未確認
  - 候補：`asp/config/web_config.asp` / C_ADMINPASSWORDの初期値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、入力項目、基本フローは実装と一致
- 0: 低リスク - 認証ロジックはソースコードで確認済み
- 0: 低リスク - バックサイト認証との差異が明確に区別されている

## 6) レビュアーチェックリスト（最小）
- [ ] ad_login.aspの処理フローが設計書と一致しているか確認
- [ ] logonEdit.aspのlogonAdmin関数の認証ロジックを確認
- [ ] lockAdmin関数のブロック条件を確認
- [ ] web_config.aspのC_ADMINPASSWORD設定を確認
- [ ] Encrypt関数とSHA256の両方が使用可能であることを確認
