---
generated_at: 2026-01-23 12:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-複数ページ検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **pagesTobeValidatedプロパティの定義**：customerクラスでの実装詳細確認
  2. **updaterプロパティの定義**：cls_pageでの実装詳細確認
  3. **検証待ち判定ロジック**：sTitleToBeValidatedとsValueToBeValidatedの判定条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_validatepages.asp` - メイン画面ソースコード
- E-02: `asp/includes/page.asp` - cls_pageクラス
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.20は複数ページ検証画面である | E-03 | ○ |
| C-02 | URLパスはasp/bs_validatepages.aspである | E-01, E-03 | ○ |
| C-03 | customer.pagesTobeValidatedでリスト取得 | E-01 (行5) | ○ |
| C-04 | For Eachでループ処理 | E-01 (行5-8) | ○ |
| C-05 | cls_page.pick()で各ページ情報取得 | E-01 (行6-7) | ○ |
| C-06 | ページタイトルをリンクで表示 | E-01 (行7) | ○ |
| C-07 | 暗号化されたIDをURLパラメータに使用 | E-01 (行7) | ○ |
| C-08 | pobj.updater.sNickNameで更新者名表示 | E-01 (行7) | ○ |
| C-09 | convertEuroDateTime()で日時フォーマット | E-01 (行7) | ○ |
| C-10 | pv.count>0で検証待ち有無を判定 | E-01 (行5) | ○ |
| C-11 | 検証待ちなしで「No pages to validate.」表示 | E-01 (行8) | ○ |
| C-12 | bs_default.aspへの戻るリンク | E-01 (行9) | ○ |
| C-13 | ul/liでリスト形式表示 | E-01 (行5-8) | ○ |
| C-14 | 関連機能はページ検証(No.98) | E-04 | ○ |
| C-15 | pagesTobeValidatedプロパティ定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- customer.pagesTobeValidatedプロパティの定義ファイルが確認できていない
  - 候補：customer.asp / includes/customer.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧表示の基本フローは明確に確認できた
- 1: 中リスク - pagesTobeValidatedのSQL条件の詳細確認推奨
- 0: 低リスク - データ更新なしの参照のみ画面

## 6) レビュアーチェックリスト（最小）
- [ ] 検証待ちページが正しくリスト表示されることを確認
- [ ] 検証待ちがない場合に適切なメッセージが表示されることを確認
- [ ] ページタイトルリンクから個別検証画面に正しく遷移することを確認
- [ ] 更新者名と更新日時が正しく表示されることを確認
- [ ] フロントサイト編集後、このリストに反映されることを確認
