---
generated_at: 2026-01-23 23:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：200-404エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_404.asp` - 本画面のソースコード（41行）
- E-02: `asp/bs_security.asp` - セキュリティ・権限制御コード
- E-03: `asp/bs_header.asp` - メニュー定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bCustom404権限でアクセス制御 | E-01 (2行目: logon.hasaccess secondAdmin.bCustom404) | ○ |
| C-02 | postbackフラグでPOST判定 | E-01 (4-5行目: postback=convertBool(request.form("postback"))) | ○ |
| C-03 | bCustom404はチェックボックス入力 | E-01 (31行目: type="checkbox" name="bCustom404") | ○ |
| C-04 | sCustom404Titleは最大250文字に切り詰め | E-01 (10行目: left(request.form("sCustom404Title"),250)) | ○ |
| C-05 | i404TemplateIDはdecryptで復号 | E-01 (12行目: decrypt(request.form("i404TemplateID"))) | ○ |
| C-06 | customer.save()でデータベース保存 | E-01 (14行目: customer.save()) | ○ |
| C-07 | 保存成功時にbs_404.asp?fbMessage=fb_saveOKへリダイレクト | E-01 (15行目: response.redirect) | ○ |
| C-08 | デフォルトタイトルは"File Not Found" | E-01 (20行目) | ○ |
| C-09 | デフォルト本文に[404FILENAME]プレースホルダー使用 | E-01 (21行目) | ○ |
| C-10 | dumpFCKInstance()でWYSIWYGエディタ生成 | E-01 (36行目) | ○ |
| C-11 | customer.showSelectedtemplate()でテンプレート選択肢生成 | E-01 (37行目) | ○ |
| C-12 | sanitize()でXSS対策 | E-01 (35行目: sanitize(customer.sCustom404Title)) | ○ |
| C-13 | メニュー表示条件はcustomer.bUserFriendlyURL AND secondAdmin.bCustom404 | E-03 (414-421行目) | ○ |
| C-14 | secondAdmin.bCustom404のデフォルト値はtrue | E-02 (72行目) | ○ |
| C-15 | sCustom404Titleの入力欄サイズは70文字 | E-01 (35行目: size="70") | ○ |
| C-16 | sCustom404Titleの最大長は255文字 | E-01 (35行目: maxlength="255") | ○ |
| C-17 | 機能マッピングでカスタム404ページ設定(35)に関連 | E-05 (200行目) | ○ |
| C-18 | POSTメソッドで送信 | E-01 (28行目: method="post") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが完全に参照でき、すべての主張に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] bs_404.aspのソースコードが設計書と一致しているか確認
- [ ] カスタム404ページが正しく表示されるか確認
- [ ] [404FILENAME]プレースホルダーが正しく展開されるか確認
- [ ] ユーザーフレンドリーURL無効時にメニューが非表示になるか確認
- [ ] customer.save()の保存処理が正常に動作するか確認
