---
generated_at: 2026-01-23 21:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-検索画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ヘッダーメニューからのアクセス方法**：画面遷移図に基づく推定、実際のヘッダー実装要確認
  2. **検索対象イントラネットメッセージ**：fullsearch.aspでは実装されているが使用頻度要確認
  3. **新しいウィンドウで開く動作**：target='_blank'の記述確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_search.asp` - 検索画面メインソースコード（行1-21）
- E-02: `asp/includes/fullsearch.asp` - cls_fullSearchクラス定義（行1-401）
- E-03: `asp/bs_security.asp` - セキュリティ処理
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行22）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行34）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「検索画面」でURLはbs_search.asp | E-01, E-04 | ○ |
| C-02 | 機能No.97「バックオフィス検索」に対応 | E-05 | ○ |
| C-03 | セカンドアドミンはbs_default.aspへリダイレクト | E-01（行4） | ○ |
| C-04 | cls_fullSearchクラスで全文検索を実行 | E-01（行10-13）, E-02 | ○ |
| C-05 | CSRF対策が実装されている | E-01（行8）checkCSRF() | ○ |
| C-06 | 正規表現ベースで検索実行 | E-02（行8-11）re=new regexp | ○ |
| C-07 | ページ検索機能 | E-02（行79-93）pages関数 | ○ |
| C-08 | 定数検索機能 | E-02（行94-108）constants関数 | ○ |
| C-09 | フォーム検索機能 | E-02（行109-123）forms関数 | ○ |
| C-10 | フォームフィールド検索機能 | E-02（行124-138）formFields関数 | ○ |
| C-11 | テンプレート検索機能 | E-02（行139-153）templates関数 | ○ |
| C-12 | フィード検索機能 | E-02（行154-168）feeds関数 | ○ |
| C-13 | 投票検索機能 | E-02（行169-183）polls関数 | ○ |
| C-14 | ギャラリー検索機能 | E-02（行184-198）galleries関数 | ○ |
| C-15 | テーマ検索機能 | E-02（行199-213）themes関数 | ○ |
| C-16 | 検索結果0件時のメッセージ表示 | E-01（行17）l("thereAre"), l("resultsForSearch") | ○ |
| C-17 | 検索結果リンクは新規ウィンドウで開く | E-02（行302-368）target='_blank' | ○ |
| C-18 | バックサイトホームからのアクセス | E-06 | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：画面遷移図ではバックサイトホームからの遷移経路が明示的に記載されていないが、ヘッダーメニューの実装（bs_header.asp）の詳細確認が必要
  - 候補：bs_header.asp / bs_menu.asp / includes/header.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードに基づく根拠が充実
- 1: 中リスク - 画面遷移の起点についてはヘッダー実装の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] セカンドアドミンのリダイレクト動作が実際に期待通りか確認
- [ ] 検索対象となるテーブル一覧が漏れなく記載されているか確認
- [ ] 検索結果リンクのtarget='_blank'が全項目で適用されているか確認
- [ ] CSRF対策の実装が適切か確認
