---
generated_at: 2026-01-23 21:48:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-プレビュー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **コメントアウトされた機能**：ページブロック編集リンクの将来的な有効化可能性
  3. **encrypt関数の動作**：暗号化処理の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_preview.asp` - プレビュー画面ソースコード（行1-19）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行23）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行35）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「プレビュー画面」でURLはbs_preview.asp | E-01, E-02 | ○ |
| C-02 | 機能No.17「ページプレビュー」に対応 | E-03 | ○ |
| C-03 | page.iIDが0以外の場合にリンク表示 | E-01（行3） | ○ |
| C-04 | Mediaリンクはbs_itemmedia.aspへ遷移 | E-01（行5） | ○ |
| C-05 | リストページアイテムはiListPageID > 0で判定 | E-01（行7） | ○ |
| C-06 | リストページのURLにはitem=とアンカーが含まれる | E-01（行8） | ○ |
| C-07 | 通常ページはiID=のみのURL | E-01（行14） | ○ |
| C-08 | プレビューは新しいウィンドウで開く | E-01（行8,14）target="_blank" | ○ |
| C-09 | secondAdmin.bSetupPageElements権限で表示制御 | E-01（行11） | ○ |
| C-10 | ページブロック編集リンクはコメントアウト状態 | E-01（行12） | ○ |
| C-11 | encrypt関数でIDを暗号化 | E-01（行5,8,14） | ○ |
| C-12 | getArtLink関数でリンクHTML生成 | E-01（行8,14） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが短く、全行にわたり根拠確認完了
- 0: 低リスク - シンプルな処理のため複雑なバグの可能性低い

## 6) レビュアーチェックリスト（最小）
- [ ] page.iListPageIDの判定ロジックが正しいか確認
- [ ] encrypt関数によるID暗号化がセキュリティ上適切か確認
- [ ] コメントアウトされたページブロック編集機能の今後の扱いを確認
- [ ] Mediaリンクのポップアップ動作が期待通りか確認
