---
generated_at: 2026-01-23 21:52:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-フォーム一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **複製機能のトランザクション**：copy()のエラー処理確認推奨
  3. **権限チェックの網羅性**：bFormExport権限の適用範囲確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formList.asp` - フォーム一覧画面ソースコード（行1-10）
- E-02: `asp/includes/form.asp` - cls_formクラス定義（行1-887）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行24）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行36-40）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォーム一覧」でURLはbs_formList.asp | E-01, E-03 | ○ |
| C-02 | 機能No.39「フォーム一覧」に対応 | E-04 | ○ |
| C-03 | secondAdmin.bForms権限でアクセス制御 | E-01（行4）logon.hasaccess | ○ |
| C-04 | customer.formsからフォーム一覧取得 | E-01（行8） | ○ |
| C-05 | 新規フォーム作成リンクはbs_formEdit.aspへ遷移 | E-01（行8） | ○ |
| C-06 | フォーム名クリックでbs_formEdit.aspへ遷移 | E-01（行9） | ○ |
| C-07 | フィールド設定アイコンでbs_formFields.aspへ遷移 | E-01（行9）getIcon | ○ |
| C-08 | プレビューアイコンはポップアップで開く | E-01（行9）getIconPP, class="QSPP" | ○ |
| C-09 | データアイコンはbFormExport権限で制御 | E-01（行9）if secondAdmin.bFormExport | ○ |
| C-10 | Excelアイコンはwindow.openで新規ウィンドウ | E-01（行9）javascript:window.open | ○ |
| C-11 | 複製アイコンは確認ダイアログ表示 | E-01（行9）confirm('areyousuretocopy') | ○ |
| C-12 | 複製処理はcls_form.copy()で実行 | E-01（行6）, E-02（行839-851） | ○ |
| C-13 | copy()はフィールドも含めて複製 | E-02（行846-848） | ○ |
| C-14 | 複製時の名前は"コピー " + 元の名前 | E-02（行844）l("copyof") | ○ |
| C-15 | フォームIDはencrypt関数で暗号化 | E-01（行9）encrypt(formKey) | ○ |
| C-16 | フォーム0件時は「フォームがありません」表示 | E-01（行9）l("noforms") | ○ |
| C-17 | iIDはイタリック表示 | E-01（行9）<i>iID: | ○ |
| C-18 | CSRFトークンはQS_secCodeURLで付与 | E-01（行9） | ○ |
| C-19 | テーブル形式で一覧表示 | E-01（行8-9） | ○ |
| C-20 | アイコンはgetIcon/getIconPP関数で生成 | E-01（行9） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく根拠が充実
- 1: 中リスク - 複製機能のエラー処理・トランザクション管理の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bForms権限チェックが正しく動作するか確認
- [ ] secondAdmin.bFormExport権限でData/Excelアイコンが制御されるか確認
- [ ] フォーム複製時にフィールドも正しく複製されるか確認
- [ ] 複製時のCSRFトークン検証が適切か確認
- [ ] encrypt関数によるID暗号化がセキュリティ上適切か確認
