---
generated_at: 2026-01-23 21:58:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：24-フォーム編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **送信時スクリプト実行のセキュリティ**：execute関数の使用はセキュリティリスク要確認
  2. **メールアドレスバリデーション**：CheckEmailSyntax関数の実装詳細確認推奨
  3. **[QS_COPYSUBMISSION]プレースホルダー**：動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formEdit.asp` - フォーム編集画面ソースコード（行1-46）
- E-02: `asp/includes/form.asp` - cls_formクラス定義（行1-887）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行25）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行41-42）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォーム編集」でURLはbs_formEdit.asp | E-01, E-03 | ○ |
| C-02 | 機能No.40「フォーム作成・編集」に対応 | E-04 | ○ |
| C-03 | secondAdmin.bForms権限でアクセス制御 | E-01（行4）logon.hasaccess | ○ |
| C-04 | 他顧客のフォームへのアクセス防止 | E-01（行11-13） | ○ |
| C-05 | フォーム名は必須項目 | E-02（行66-69）check関数 | ○ |
| C-06 | ボタンラベルは必須項目 | E-02（行70-73）check関数 | ○ |
| C-07 | Q&A配置は必須項目 | E-02（行74-77）check関数 | ○ |
| C-08 | フィードバックとリダイレクトは排他 | E-02（行78-81）check関数 | ○ |
| C-09 | 自動応答設定の条件付き必須チェック | E-02（行82-104）check関数 | ○ |
| C-10 | メール送信設定の条件付き必須チェック | E-02（行109-129）check関数 | ○ |
| C-11 | メールアドレス形式チェック | E-02（行99-102,118-121）CheckEmailSyntax | ○ |
| C-12 | 新規保存後はフォームフィールド画面へリダイレクト | E-01（行22-23） | ○ |
| C-13 | 編集保存後はフォーム一覧画面へリダイレクト | E-01（行24-25） | ○ |
| C-14 | 削除時はsubmissions、fields、Form全て削除 | E-02（行210-231）remove関数 | ○ |
| C-15 | 削除時はtblPageのiFormIDをnullに更新 | E-02（行225） | ○ |
| C-16 | 削除時はtblCatalogのiFormIDをnullに更新 | E-02（行227） | ○ |
| C-17 | 自動応答チェックボックスでフォーム自動送信 | E-01（行41）onclick="javascript:document.mainform.submit();" | ○ |
| C-18 | メール送信チェックボックスでフォーム自動送信 | E-01（行45）onclick="javascript:document.mainform.submit();" | ○ |
| C-19 | リダイレクトURLからhttp://,https://は自動除去 | E-02（行105-108） | ○ |
| C-20 | CSRFトークン検証が実装されている | E-01（行16,28）checkCSRF() | ○ |
| C-21 | customer.bApplication権限で送信時スクリプト表示 | E-01（行45） | ○ |
| C-22 | フォームIDはencrypt関数で暗号化 | E-01（行33） | ○ |
| C-23 | dCreatedTSは新規作成時のみ設定 | E-02（行147） | ○ |
| C-24 | dUpdatedTSは保存時に常に更新 | E-02（行167） | ○ |
| C-25 | sNameは最大255文字 | E-02（行151）left(sName,255) | ○ |
| C-26 | 宛先は改行区切りで複数指定可能 | E-02（行115）split(sTo,vbcrlf) | ○ |
| C-27 | [QS_COPYSUBMISSION]プレースホルダー機能 | E-01（行38）ヒント表示 | ○ |
| C-28 | 送信時スクリプトはexecute関数で実行 | E-02（行872-874）run関数 | △ |

## 4) 不足情報（Unknown / Missing）
- C-28について：execute関数の詳細な動作とセキュリティ対策の確認が必要
  - 候補：ASP/VBScript組み込みexecute関数 / treatConstants関数の詳細

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 送信時スクリプト機能（execute）はセキュリティリスクの可能性あり
- 1: 中リスク - メールアドレスバリデーションの網羅性確認推奨
- 0: 低リスク - その他の処理はソースコードで十分な根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bForms権限チェックが正しく動作するか確認
- [ ] 他顧客フォームへのアクセス防止が適切か確認
- [ ] フィードバックとリダイレクトの排他バリデーションが正しく動作するか確認
- [ ] メールアドレス形式チェックが適切か確認
- [ ] 削除時の関連データ削除が漏れなく行われるか確認
- [ ] execute関数によるスクリプト実行のセキュリティリスクを評価
- [ ] CSRFトークン検証が適切に機能するか確認
