---
generated_at: 2026-01-23 22:02:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-フォームフィールド一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **moveUp/moveDownの実装詳細**：cls_FormFieldのメソッド実装確認推奨
  3. **sortableクラスのJavaScript動作**：sorttable.jsの動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formFields.asp` - フォームフィールド一覧画面ソースコード（行1-20）
- E-02: `asp/includes/form.asp` - cls_formクラス、fields()メソッド（行233-249）
- E-03: `asp/includes/formFieldTypeList.asp` - フィールドタイプ定義（行1-54）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行26）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行43）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォームフィールド一覧」でURLはbs_formFields.asp | E-01, E-04 | ○ |
| C-02 | 機能No.41「フォームフィールド管理」に対応 | E-05 | ○ |
| C-03 | secondAdmin.bForms権限でアクセス制御 | E-01（行4）logon.hasaccess | ○ |
| C-04 | form.fieldsからフィールド一覧取得 | E-01（行16）, E-02 | ○ |
| C-05 | フィールドはiRang昇順でソート | E-02（行238）order by iRang asc | ○ |
| C-06 | btnaction=MoveUPでmoveUp()実行 | E-01（行7-9） | ○ |
| C-07 | btnaction=MoveDOWNでmoveDown()実行 | E-01（行10-12） | ○ |
| C-08 | 並び順変更時にCSRFチェック実行 | E-01（行8,11）checkCSRF() | ○ |
| C-09 | フォーム名は太字で表示 | E-01（行18）<b>form.sName</b> | ○ |
| C-10 | 新規フィールドリンクは編集画面へ遷移 | E-01（行18） | ○ |
| C-11 | プレビューアイコンはポップアップで開く | E-01（行18）getIconPP, class="QSPP" | ○ |
| C-12 | テーブルにclass="sortable"が設定 | E-01（行18） | ○ |
| C-13 | フィールドタイプ表示名はshowSelectedで取得 | E-01（行19）fixedFieldTypeList.showSelected | ○ |
| C-14 | フィールドIDはencrypt関数で暗号化 | E-01（行18,19）encrypt(ffKey) | ○ |
| C-15 | 上下アイコンはgetIcon関数で生成 | E-01（行19） | ○ |
| C-16 | QS_secCodeURLでCSRFトークン付与 | E-01（行19） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく根拠が充実
- 1: 中リスク - moveUp/moveDownメソッドの実装詳細は別ファイルのため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bForms権限チェックが正しく動作するか確認
- [ ] MoveUP/MoveDOWN処理でCSRF検証が適切か確認
- [ ] フィールド一覧のiRang昇順ソートが正しく動作するか確認
- [ ] sortableテーブルのJavaScript動作が期待通りか確認
- [ ] encrypt関数によるID暗号化がセキュリティ上適切か確認
