---
generated_at: 2026-01-23 22:08:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-フォームフィールド編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **FCKEditorの動作**：createFCKInstance関数の実装確認推奨
  3. **ファイルアップロード設定**：sFileLocation, sAllowedExtensionsの検証確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_FormFieldEdit.asp` - フォームフィールド編集画面ソースコード（行1-40）
- E-02: `asp/includes/formFieldTypeList.asp` - フィールドタイプ定数定義（行1-54）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行27）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行44）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォームフィールド編集」でURLはbs_FormFieldEdit.asp | E-01, E-03 | ○ |
| C-02 | 機能No.41「フォームフィールド管理」に対応 | E-04 | ○ |
| C-03 | secondAdmin.bForms権限でアクセス制御 | E-01（行2）logon.hasaccess | ○ |
| C-04 | フィールドタイプ変更でフォーム自動送信 | E-01（行22）onchange="javascript:document.mainform.submit();" | ○ |
| C-05 | text/url/emailでプレースホルダー表示 | E-01（行24-30）select case | ○ |
| C-06 | textareaで列数/行数/最大長設定 | E-01（行34-37） | ○ |
| C-07 | select/radioで選択肢設定 | E-01（行38） | ○ |
| C-08 | radioで複数選択許可オプション | E-01（行38）bAllowMS | ○ |
| C-09 | radioで配置設定 | E-01（行39）sRadioPlacement | ○ |
| C-10 | file/imageでファイル設定表示 | E-01（行39） | ○ |
| C-11 | commentでリッチテキストエディタ | E-01（行39）createFCKInstance | ○ |
| C-12 | hiddenでデフォルト値設定 | E-01（行22） | ○ |
| C-13 | hiddenはcustomer.bApplicationで制御 | E-02（行31）if customer.bApplication | ○ |
| C-14 | emailで自動応答有効オプション | E-01（行39）bAutoResponder | ○ |
| C-15 | emailで送信者メール使用オプション | E-01（行39）bUseForSending | ○ |
| C-16 | comment/hidden以外で必須チェック表示 | E-01（行39） | ○ |
| C-17 | 新規作成時の順序はフィールド数+1 | E-01（行33-37） | ○ |
| C-18 | CSRFトークン検証が実装されている | E-01（行11,15）checkCSRF() | ○ |
| C-19 | 保存後はbs_formFields.aspへリダイレクト | E-01（行13） | ○ |
| C-20 | 削除時は確認ダイアログ表示 | E-01（行39）confirm | ○ |
| C-21 | sb_ff_text="10"等の定数定義 | E-02（行2-14） | ○ |
| C-22 | フィールドIDはencrypt関数で暗号化 | E-01（行22） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく根拠が充実
- 1: 中リスク - ファイルアップロード設定のセキュリティ検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bForms権限チェックが正しく動作するか確認
- [ ] フィールドタイプ変更時の画面リロードが正しく動作するか確認
- [ ] 各フィールドタイプ固有の設定項目が正しく表示されるか確認
- [ ] ファイルアップロード設定（保存先、許可拡張子）のセキュリティを確認
- [ ] FCKEditorによるリッチテキスト編集が正しく動作するか確認
- [ ] CSRFトークン検証が適切に機能するか確認
