---
generated_at: 2026-01-23 22:12:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-フォームプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **build()メソッドの動作**：form.build()の全オプションの動作確認推奨
  3. **ポップアップ表示**：QSPPクラスの動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formPreview.asp` - フォームプレビュー画面ソースコード（行1-7）
- E-02: `asp/includes/form.asp` - cls_formクラス、build()メソッド（行250-805）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行28）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行45）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォームプレビュー」でURLはbs_formPreview.asp | E-01, E-03 | ○ |
| C-02 | 機能No.44「フォームプレビュー」に対応 | E-04 | ○ |
| C-03 | secondAdmin.bForms権限でアクセス制御 | E-01（行4）logon.hasaccess | ○ |
| C-04 | form.build()でフォームHTML生成 | E-01（行5）, E-02 | ○ |
| C-05 | action="bs_formPreview.asp"で自画面送信 | E-01（行5）build("bs_formPreview.asp",...) | ○ |
| C-06 | align="center"で中央配置 | E-01（行5）build(...,"center",...) | ○ |
| C-07 | buttonType="button"でボタン表示 | E-01（行5）build(...,"button",...) | ○ |
| C-08 | itemID=nullでカタログ非紐付け | E-01（行5）build(...,null) | ○ |
| C-09 | 表示幅680pxに固定 | E-01（行4）style="width:680px" | ○ |
| C-10 | 独立HTMLドキュメントとして出力 | E-01（行4）DOCTYPE宣言 | ○ |
| C-11 | cleanUPASPでリソース解放 | E-01（行6） | ○ |
| C-12 | 背景色は白（#FFFFFF） | E-01（行4）background-color:#FFFFFF | ○ |
| C-13 | ポップアップ表示される | E-03 class="QSPP" | ○ |
| C-14 | データベース更新なし | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードがシンプルで明確
- 0: 低リスク - 読み取り専用画面のため副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bForms権限チェックが正しく動作するか確認
- [ ] form.build()で生成されるHTMLが期待通りか確認
- [ ] ポップアップウィンドウとして正しく表示されるか確認
- [ ] 各フィールドタイプのプレビューが正しく表示されるか確認
- [ ] CAPTCHAのプレビューが正しく表示されるか確認
