---
generated_at: 2026-01-23 22:18:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-フォームデータエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **削除処理の動作**：remove()メソッドとremoveAllSubmissions()の確認推奨
  3. **ファイル削除処理**：ファイル/画像フィールドの物理削除処理確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formExport.asp` - フォームデータエクスポート画面ソースコード（行1-50）
- E-02: `asp/includes/submission.asp` - cls_submissionクラス、remove()メソッド（行1-150）
- E-03: `asp/includes/form.asp` - cls_formクラス、submissions()メソッド（行824-838）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行29）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行46）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォームデータエクスポート」でURLはbs_formExport.asp | E-01, E-04 | ○ |
| C-02 | 機能No.42「フォーム送信データ表示」に対応 | E-05 | ○ |
| C-03 | secondAdmin.bFormExport権限でアクセス制御 | E-01（行3）logon.hasaccess | ○ |
| C-04 | 送信データ一覧を表示する | E-01（行17-49）ループ処理 | ○ |
| C-05 | 個別削除はiSubmissionIDパラメータで指定 | E-01（行9-12） | ○ |
| C-06 | 全件削除はpageAction=removeAllで実行 | E-01（行13-16） | ○ |
| C-07 | 削除時にCSRFトークン検証を実施 | E-01 checkCSRF() | ○ |
| C-08 | cls_submissionのremove()で個別削除 | E-02 remove()メソッド | ○ |
| C-09 | form.removeAllSubmissions()で全件削除 | E-03 | ○ |
| C-10 | 削除時にファイル/画像フィールドの物理ファイル削除 | E-02 ファイル削除処理 | ○ |
| C-11 | 送信日時はformatTimeStamp形式で表示 | E-01（行35） | ○ |
| C-12 | カタログ連携時はカタログ名・アイテム名を表示 | E-01（行28-31） | ○ |
| C-13 | Excelアイコンでbs_formExcel.aspを新規ウィンドウで開く | E-01（行20） | ○ |
| C-14 | テーブルにclass=\"sortable\"が設定 | E-01（行22） | ○ |
| C-15 | ファイル/画像フィールドはリンクとして表示 | E-01（行36-40）select case | ○ |
| C-16 | checkboxはYes/Noに変換して表示 | E-01（行41） | ○ |
| C-17 | 編集リンクでbs_formSubmissionEdit.aspへ遷移 | E-01（行33） | ○ |
| C-18 | データ0件時は「データがありません」メッセージ | E-01（行48） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく根拠が充実
- 1: 中リスク - 削除処理のロールバック処理の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bFormExport権限チェックが正しく動作するか確認
- [ ] 個別削除時にCSRFトークン検証が正しく動作するか確認
- [ ] 全件削除時にCSRFトークン検証が正しく動作するか確認
- [ ] ファイル/画像フィールドの物理ファイル削除が正しく行われるか確認
- [ ] Excelエクスポートリンクが正しく動作するか確認
- [ ] カタログ連携データが正しく表示されるか確認
