---
generated_at: 2026-01-23 22:22:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-フォームExcel出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **ファイル生成処理**：CreateTextFileのエラー処理確認推奨
  3. **文字コード変換**：convertTo_iso_8859_1の動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formExcel.asp` - フォームExcel出力画面ソースコード（行1-66）
- E-02: `asp/includes/excelFile.asp` - cls_excelFileクラス定義（行1-54）
- E-03: `asp/includes/form.asp` - cls_formクラス、submissions()メソッド（行824-838）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行30）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行47）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォームExcel出力」でURLはbs_formExcel.asp | E-01, E-04 | ○ |
| C-02 | 機能No.43「フォームデータExcelエクスポート」に対応 | E-05 | ○ |
| C-03 | secondAdmin.bFormExport権限でアクセス制御 | E-01（行4）logon.hasaccess | ○ |
| C-04 | cls_excelFileクラスでExcelファイル生成 | E-01（行63-64）, E-02 | ○ |
| C-05 | HTMLテーブル形式でデータを生成 | E-01（行15-61） | ○ |
| C-06 | ファイル名は「IEExport_{パスワード}.xls」形式 | E-02（行7-8, 33-34） | ○ |
| C-07 | 生成時に古いエクスポートファイルを削除 | E-02（行17, 39-53）deleteOthers() | ○ |
| C-08 | redirectLink()でファイルダウンロード | E-01（行65）, E-02（行36-38） | ○ |
| C-09 | カタログ連携時はカタログ名・アイテム名を出力 | E-01（行17-20, 34-37） | ○ |
| C-10 | checkboxはconvertCheckedYesNo()で変換 | E-01（行42-43） | ○ |
| C-11 | file/imageはlinkUrls()でURL出力 | E-01（行44-49） | ○ |
| C-12 | commentフィールドは出力対象外 | E-01（行22, 39）sb_ff_comment除外 | ○ |
| C-13 | 文字コード変換にconvertTo_iso_8859_1使用 | E-02（行16） | ○ |
| C-14 | prepareForExport()でエクスポート準備 | E-02（行16） | ○ |
| C-15 | ファイル保存先はQS_CMS_userfilesディレクトリ | E-02（行19, 31, 37, 42） | ○ |
| C-16 | データベース更新は行わない（読み取り専用） | E-01 SELECT処理のみ | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく根拠が充実
- 1: 中リスク - ファイル生成時のエラー処理（on error resume next）の安全性確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bFormExport権限チェックが正しく動作するか確認
- [ ] Excelファイルが正しく生成・ダウンロードされるか確認
- [ ] 古いエクスポートファイルが正しく削除されるか確認
- [ ] カタログ連携データが正しくエクスポートされるか確認
- [ ] 各フィールドタイプのデータが正しく出力されるか確認
- [ ] 文字コード変換が正しく行われるか確認（日本語データ）
