---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ログオフ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目で根拠確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_logoff.asp` 行1-11
- E-02: `asp/includes/logonEdit.asp` 行183-188
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行4
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行7
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` 行34-35

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_logoff.asp である | E-03 | ○ |
| C-02 | loggedoffパラメータでモード切替 | E-01 行4 | ○ |
| C-03 | logon.logoffBO関数が呼び出される | E-01 行5 | ○ |
| C-04 | Cookie（cId&"hfsdsiiqqssdfjf"）がクリアされる | E-01 行6 | ○ |
| C-05 | Session(cId & "isAUTHENTICATEDSecondAdmin")がfalseになる | E-01 行7 | ○ |
| C-06 | Session(cId & "isAUTHENTICATED")がfalseになる | E-01 行8 | ○ |
| C-07 | bs_login.aspにリダイレクトされる | E-01 行9 | ○ |
| C-08 | logoffBO関数でSession.Abandonが呼ばれる | E-02 行187 | ○ |
| C-09 | QS_CMS_FCK_allowedIPがクリアされる | E-02 行184 | ○ |
| C-10 | メニューキャッシュがクリアされる | E-02 行185-186 | ○ |
| C-11 | bs_security.aspがインクルードされる | E-01 行4 | ○ |
| C-12 | bUseArtLoginTemplateがtrue設定 | E-01 行4 | ○ |
| C-13 | youareloggedoffメッセージが表示される | E-01 行10 | ○ |
| C-14 | loginagainリンクが表示される | E-01 行10 | ○ |
| C-15 | 多言語対応されている（l関数使用） | E-01 行10 | ○ |
| C-16 | bs_endBack.aspでページが閉じられる | E-01 行10 | ○ |
| C-17 | リダイレクト先はQS_backsite_login_page変数で指定 | E-01 行9-10 | ○ |
| C-18 | 機能No.2「管理者ログアウト」に対応 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな処理であり、実装も明確
- 0: 低リスク - 全項目で根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_logoff.aspの処理フローが設計書と一致しているか確認
- [ ] logoffBO関数の処理内容を確認
- [ ] Session.Abandonの動作確認
- [ ] リダイレクト後のメッセージ表示を確認
