---
generated_at: 2026-01-23 22:25:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-フォーム送信編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり
  2. **更新処理のトランザクション**：on error resume nextの安全性確認推奨
  3. **フォームID整合性チェック**：不正アクセス防止の動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formSubmissionEdit.asp` - フォーム送信編集画面ソースコード（行1-45）
- E-02: `asp/includes/submission.asp` - cls_submissionクラス定義（行1-150）
- E-03: `asp/includes/form.asp` - cls_formクラス、fields()メソッド（行1-887）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（行31）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行46）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「フォーム送信編集」でURLはbs_formSubmissionEdit.asp | E-01, E-04 | ○ |
| C-02 | 機能No.42「フォーム送信データ表示」に対応 | E-05 | ○ |
| C-03 | secondAdmin.bFormExport権限でアクセス制御 | E-01（行4）logon.hasaccess | ○ |
| C-04 | フォームIDと送信データのフォームIDを整合性チェック | E-01（行8）if submission.iFormID<>form.iId | ○ |
| C-05 | 不一致時はresponse.endで処理終了 | E-01（行8）response.end | ○ |
| C-06 | file/imageフィールドは編集対象外 | E-01（行14-15, 35-36）select case | ○ |
| C-07 | テキストエリアは80列×3行 | E-01（行38）cols="80" rows="3" | ○ |
| C-08 | フィールドIDは暗号化されている | E-01（行24, 38）encrypt(cField) | ○ |
| C-09 | 既存レコード確認後に更新処理 | E-01（行17-26）SELECT/addNew/update | ○ |
| C-10 | レコードがない場合は新規作成 | E-01（行19-23）if rs.eof then addNew | ○ |
| C-11 | 保存時に確認ダイアログ表示 | E-01（行44）confirm | ○ |
| C-12 | 保存後はbs_formExport.aspへリダイレクト | E-01（行31）response.redirect | ○ |
| C-13 | リダイレクトにはアンカーが付与 | E-01（行31）"#" & encrypt(submission.iId) | ○ |
| C-14 | 戻るリンクでbs_formExport.aspへ遷移 | E-01（行32）href="bs_formExport.asp | ○ |
| C-15 | postback=trueで保存処理を実行 | E-01（行9-10）postback/if postback then | ○ |
| C-16 | on error resume nextでエラー抑制 | E-01（行11, 30, 32, 41） | ○ |
| C-17 | フィールド名はcleanUpStr()でサニタイズ | E-01（行38）cleanUpStr(fields(cField).sName) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張についてソースコードに根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく根拠が充実
- 1: 中リスク - データベース更新のトランザクション処理（on error resume next）の安全性確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bFormExport権限チェックが正しく動作するか確認
- [ ] フォームIDと送信データのフォームID整合性チェックが正しく動作するか確認
- [ ] file/imageフィールドが正しくスキップされるか確認
- [ ] 既存レコードがない場合の新規作成が正しく動作するか確認
- [ ] 保存後のリダイレクトが正しく行われるか確認
- [ ] アンカー付きリダイレクトで一覧画面の該当行にスクロールするか確認
