---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-ギャラリー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **多言語ラベルの実際の表示文言**：ラベルキーは確認できるが、実際の表示文言は言語ファイル依存
  2. **customer.galleriesの実装詳細**：customer.galleriesプロパティの実装は別ファイルにあり詳細未確認
  3. **セッション管理の詳細**：begin.aspの完全な実装は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_galleryList.asp` - ギャラリー一覧画面ソースコード
- E-02: `asp/includes/gallery.asp` - cls_galleryクラス定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面ファイルはbs_galleryList.asp | E-01, E-03 | ○ |
| C-02 | secondAdmin.bGallery権限が必要 | E-01 行4「logon.hasaccess secondAdmin.bGallery」 | ○ |
| C-03 | 新規ギャラリー作成リンクが表示される | E-01 行9「getArtLink("bs_galleryEdit.asp",l("newgallery")」 | ○ |
| C-04 | ギャラリー名クリックで編集画面に遷移 | E-01 行10「bs_galleryEdit.asp?iGalleryID」 | ○ |
| C-05 | プレビューアイコンでプレビュー画面に遷移 | E-01 行10「bs_galleryPreview.asp?iGalleryID」 | ○ |
| C-06 | コピーアイコンでギャラリー複製が可能 | E-01 行10「copyItem」, E-02 行687-694「copy()」 | ○ |
| C-07 | コピー時にCSRF対策トークンが使用される | E-01 行10「QS_secCodeURL」 | ○ |
| C-08 | 埋め込みコードが[QS_GALLERY:コード]形式 | E-01 行10「[QS_GALLERY:<%=sanitize(galleries(galleryKey).sCode)%>]」 | ○ |
| C-09 | ギャラリー0件時にnogalleryメッセージ表示 | E-01 行10「l("nogallery")」 | ○ |
| C-10 | コピー確認ダイアログが表示される | E-01 行10「confirm('"& l("areyousuretocopy") &"')」 | ○ |
| C-11 | cls_galleryクラスにcopyメソッドが存在 | E-02 行687-694 | ○ |
| C-12 | コピー時に新しい名前が「コピー元 のコピー」になる | E-02 行690「sName=l("copyof") & " " & sName」 | ○ |
| C-13 | コピー時にコードが自動生成される | E-02 行691「sCode=GeneratePassWord()」 | ○ |
| C-14 | tblGalleryテーブルからデータ取得 | E-02 行65「select * from tblGallery」 | ○ |
| C-15 | iCustomerIDで顧客ごとにデータ分離 | E-02 行65「iCustomerID="&cid」 | ○ |
| C-16 | 関連機能No.56がギャラリー一覧 | E-04 行49 | ○ |
| C-17 | 関連機能No.57がギャラリー作成・編集 | E-04 行50 | ○ |
| C-18 | 多言語ラベルの実際の表示文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 多言語ラベルファイル（l()関数で参照されるラベル定義）の実際の文言
  - 候補：labels.asp / language.asp / 多言語設定ファイル
- customer.galleriesプロパティの実装詳細
  - 候補：customer.asp / includes/customer.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的にソースコードとの整合性が高い
- **1: 中リスク** - 多言語ラベルの実際表示文言は言語設定により変動する可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] secondAdmin.bGallery権限の動作確認（権限なし時のリダイレクト）
- [ ] コピー機能の動作確認（新規ギャラリーの名前・コード生成）
- [ ] 埋め込みコードの実際の動作確認
- [ ] ギャラリー0件時のメッセージ表示確認
